/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.opentripplanner.datastore.CompositeDataSource;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.datastore.OtpDataStoreConfig;
import org.opentripplanner.datastore.base.DataSourceRepository;
import org.opentripplanner.datastore.base.LocalDataSourceRepository;

public class OtpDataStore {
    public static final String BUILD_REPORT_DIR = "report";
    private static final String STREET_GRAPH_FILENAME = "streetGraph.obj";
    private static final String GRAPH_FILENAME = "graph.obj";
    private final OtpDataStoreConfig config;
    private final List<String> repositoryDescriptions = new ArrayList<String>();
    private final List<DataSourceRepository> allRepositories;
    private final LocalDataSourceRepository localRepository;
    private final Multimap<FileType, DataSource> sources = ArrayListMultimap.create();
    private DataSource streetGraph;
    private DataSource graph;
    private CompositeDataSource buildReportDir;

    public OtpDataStore(OtpDataStoreConfig config, List<DataSourceRepository> repositories) {
        this.config = config;
        this.repositoryDescriptions.addAll(repositories.stream().map(DataSourceRepository::description).collect(Collectors.toList()));
        this.allRepositories = repositories;
        this.localRepository = this.getLocalDataSourceRepo(repositories);
    }

    public void open() {
        this.allRepositories.forEach(DataSourceRepository::open);
        this.addAll(this.localRepository.listExistingSources(FileType.CONFIG));
        this.addAll(this.findMultipleSources(this.config.osmFiles(), FileType.OSM));
        this.addAll(this.findMultipleSources(this.config.demFiles(), FileType.DEM));
        this.addAll(this.findMultipleCompositeSources(this.config.gtfsFiles(), FileType.GTFS));
        this.addAll(this.findMultipleCompositeSources(this.config.netexFiles(), FileType.NETEX));
        this.streetGraph = this.findSingleSource(this.config.streetGraph(), STREET_GRAPH_FILENAME, FileType.GRAPH);
        this.graph = this.findSingleSource(this.config.graph(), GRAPH_FILENAME, FileType.GRAPH);
        this.buildReportDir = this.findCompositeSource(this.config.reportDirectory(), BUILD_REPORT_DIR, FileType.REPORT);
        this.addAll(Arrays.asList(this.streetGraph, this.graph, this.buildReportDir));
        this.addAll(this.findMultipleSources(Collections.emptyList(), FileType.UNKNOWN));
    }

    public static File graphFile(File path) {
        return new File(path, GRAPH_FILENAME);
    }

    public List<String> getRepositoryDescriptions() {
        return this.repositoryDescriptions;
    }

    @NotNull
    public Collection<DataSource> listExistingSourcesFor(FileType type) {
        return this.sources.get((Object)type).stream().filter(DataSource::exists).collect(Collectors.toList());
    }

    @NotNull
    public DataSource getStreetGraph() {
        return this.streetGraph;
    }

    @NotNull
    public DataSource getGraph() {
        return this.graph;
    }

    @NotNull
    public CompositeDataSource getBuildReportDir() {
        return this.buildReportDir;
    }

    private void add(DataSource source) {
        if (source != null) {
            this.sources.put((Object)source.type(), (Object)source);
        }
    }

    private void addAll(List<? extends DataSource> list) {
        list.forEach(this::add);
    }

    private LocalDataSourceRepository getLocalDataSourceRepo(List<DataSourceRepository> repositories) {
        List localRepos = repositories.stream().filter(it -> it instanceof LocalDataSourceRepository).map(it -> (LocalDataSourceRepository)it).collect(Collectors.toList());
        if (localRepos.size() != 1) {
            throw new IllegalStateException("Only one LocalDataSourceRepository is supported.");
        }
        return (LocalDataSourceRepository)localRepos.get(0);
    }

    private DataSource findSingleSource(@Nullable URI uri, @NotNull String filename, @NotNull FileType type) {
        if (uri != null) {
            return this.findSourceUsingAllRepos(it -> it.findSource(uri, type));
        }
        return this.localRepository.findSource(filename, type);
    }

    private CompositeDataSource findCompositeSource(@Nullable URI uri, @NotNull String filename, @NotNull FileType type) {
        if (uri != null) {
            return this.findSourceUsingAllRepos(it -> it.findCompositeSource(uri, type));
        }
        return this.localRepository.findCompositeSource(filename, type);
    }

    private List<DataSource> findMultipleSources(@NotNull Collection<URI> uris, @NotNull FileType type) {
        if (uris == null || uris.isEmpty()) {
            return this.localRepository.listExistingSources(type);
        }
        ArrayList<DataSource> result = new ArrayList<DataSource>();
        for (URI uri : uris) {
            DataSource res = this.findSourceUsingAllRepos(it -> it.findSource(uri, type));
            result.add(res);
        }
        return result;
    }

    private List<CompositeDataSource> findMultipleCompositeSources(@NotNull Collection<URI> uris, @NotNull FileType type) {
        if (uris.isEmpty()) {
            return this.localRepository.listExistingSources(type).stream().map(it -> (CompositeDataSource)it).collect(Collectors.toList());
        }
        ArrayList<CompositeDataSource> result = new ArrayList<CompositeDataSource>();
        for (URI uri : uris) {
            CompositeDataSource res = this.findSourceUsingAllRepos(it -> it.findCompositeSource(uri, type));
            result.add(res);
        }
        return result;
    }

    @Nullable
    private <T> T findSourceUsingAllRepos(Function<DataSourceRepository, T> repoFindSource) {
        for (DataSourceRepository it : this.allRepositories) {
            T res = repoFindSource.apply(it);
            if (res == null) continue;
            return res;
        }
        return null;
    }
}

