/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import org.apache.commons.io.IOUtils;
import org.opentripplanner.common.LoggingUtil;
import org.opentripplanner.datastore.FileType;

public interface DataSource {
    public String name();

    public String path();

    public FileType type();

    default public long size() {
        return -1L;
    }

    default public long lastModified() {
        return -1L;
    }

    default public boolean exists() {
        return true;
    }

    default public boolean isWritable() {
        return true;
    }

    default public InputStream asInputStream() {
        throw new UnsupportedOperationException("This datasource type " + this.getClass().getSimpleName() + " do not support READING. Can not read from: " + this.path());
    }

    default public byte[] asBytes() {
        try {
            return IOUtils.toByteArray((InputStream)this.asInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + this.path() + ": " + e.getLocalizedMessage(), e);
        }
    }

    default public OutputStream asOutputStream() {
        throw new UnsupportedOperationException("This datasource type " + this.getClass().getSimpleName() + " do not support WRITING. Can not write to: " + this.path());
    }

    default public String detailedInfo() {
        Object info = String.format("%s %s  %s", this.type().icon(), this.name(), this.directory());
        if (this.lastModified() > 0L) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            info = (String)info + "  " + sdf.format(this.lastModified());
        }
        if (this.size() > 0L) {
            info = (String)info + "  " + LoggingUtil.fileSizeToString(this.size());
        }
        return info;
    }

    private String directory() {
        int endIndex = this.path().length() - (this.name().length() + 1);
        return endIndex <= 0 ? "" : this.path().substring(0, endIndex);
    }
}

