/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common.geometry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;

public class Subgraph {
    private Set<Vertex> streetVertexSet = new HashSet<Vertex>();
    private Set<Vertex> stopsVertexSet = new HashSet<Vertex>();
    private ArrayList<Coordinate> vertexCoords = new ArrayList();
    private Geometry convexHullAsGeom = null;
    private boolean newVertexAdded = true;
    private static GeometryFactory gf = new GeometryFactory();

    public void addVertex(Vertex vertex) {
        if (vertex instanceof TransitStopVertex) {
            this.stopsVertexSet.add(vertex);
        } else {
            this.streetVertexSet.add(vertex);
        }
        this.newVertexAdded = true;
        this.vertexCoords.add(vertex.getCoordinate());
    }

    public boolean contains(Vertex vertex) {
        return this.streetVertexSet.contains(vertex) || this.stopsVertexSet.contains(vertex);
    }

    public boolean containsStreet(Vertex vertex) {
        return this.streetVertexSet.contains(vertex);
    }

    public int streetSize() {
        return this.streetVertexSet.size();
    }

    public int stopSize() {
        return this.stopsVertexSet.size();
    }

    public Vertex getRepresentativeVertex() {
        return this.streetVertexSet.iterator().next();
    }

    public Iterator<Vertex> streetIterator() {
        return this.streetVertexSet.iterator();
    }

    public Iterator<Vertex> stopIterator() {
        return this.stopsVertexSet.iterator();
    }

    public Geometry getConvexHull() {
        if (this.newVertexAdded) {
            MultiPoint mp = gf.createMultiPoint(this.vertexCoords.toArray(new Coordinate[0]));
            this.newVertexAdded = false;
            mp.convexHull();
        }
        return this.convexHullAsGeom;
    }
}

