/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common.geometry;

import org.apache.commons.math3.util.FastMath;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.common.geometry.GeometryUtils;

public abstract class SphericalDistanceLibrary {
    public static final double RADIUS_OF_EARTH_IN_KM = 6371.01;
    public static final double RADIUS_OF_EARTH_IN_M = 6371010.0;
    public static final double MAX_LAT_DELTA_DEG = 4.0;
    public static final double MAX_LON_DELTA_DEG = 4.0;
    public static final double MAX_ERR_INV = 0.999462;

    public static final double distance(Coordinate from, Coordinate to) {
        return SphericalDistanceLibrary.distance(from.y, from.x, to.y, to.x);
    }

    public static final double fastDistance(Coordinate from, Coordinate to) {
        return SphericalDistanceLibrary.fastDistance(from.y, from.x, to.y, to.x);
    }

    public static final double fastDistance(Coordinate from, Coordinate to, double cosLat) {
        double dLat = FastMath.toRadians((double)(from.y - to.y));
        double dLon = FastMath.toRadians((double)(from.x - to.x)) * cosLat;
        return 6371010.0 * FastMath.sqrt((double)(dLat * dLat + dLon * dLon));
    }

    public static final double fastDistance(Coordinate point, LineString lineString) {
        double lat = Math.toRadians(point.y);
        double cosLat = FastMath.cos((double)lat);
        double lon = Math.toRadians(point.x) * cosLat;
        Point point2 = GeometryUtils.getGeometryFactory().createPoint(new Coordinate(lon, lat));
        LineString lineString2 = SphericalDistanceLibrary.equirectangularProject(lineString, cosLat);
        return lineString2.distance((Geometry)point2) * 6371010.0;
    }

    public static double length(LineString lineString) {
        double accumulatedMeters = 0.0;
        for (int i = 1; i < lineString.getNumPoints(); ++i) {
            accumulatedMeters += SphericalDistanceLibrary.distance(lineString.getCoordinateN(i - 1), lineString.getCoordinateN(i));
        }
        return accumulatedMeters;
    }

    public static final double fastLength(LineString lineString) {
        Coordinate[] coordinates = lineString.getCoordinates();
        double middleY = (coordinates[0].y + coordinates[coordinates.length - 1].y) / 2.0;
        double cosLat = FastMath.cos((double)Math.toRadians(middleY));
        return SphericalDistanceLibrary.equirectangularProject(lineString, cosLat).getLength() * 6371010.0;
    }

    public static final double fastLength(LineString lineString, double cosLat) {
        return SphericalDistanceLibrary.equirectangularProject(lineString, cosLat).getLength() * 6371010.0;
    }

    private static LineString equirectangularProject(LineString lineString, double cosLat) {
        Coordinate[] coords = lineString.getCoordinates();
        Coordinate[] coords2 = new Coordinate[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            coords2[i] = new Coordinate(Math.toRadians(coords[i].x) * cosLat, Math.toRadians(coords[i].y));
        }
        return GeometryUtils.getGeometryFactory().createLineString(coords2);
    }

    public static final double distance(double lat1, double lon1, double lat2, double lon2) {
        return SphericalDistanceLibrary.distance(lat1, lon1, lat2, lon2, 6371010.0);
    }

    public static final double fastDistance(double lat1, double lon1, double lat2, double lon2) {
        return SphericalDistanceLibrary.fastDistance(lat1, lon1, lat2, lon2, 6371010.0);
    }

    public static final double distance(double lat1, double lon1, double lat2, double lon2, double radius) {
        lat1 = FastMath.toRadians((double)lat1);
        lon1 = FastMath.toRadians((double)lon1);
        lat2 = FastMath.toRadians((double)lat2);
        lon2 = FastMath.toRadians((double)lon2);
        double deltaLon = lon2 - lon1;
        double y = FastMath.sqrt((double)(SphericalDistanceLibrary.p2(FastMath.cos((double)lat2) * FastMath.sin((double)deltaLon)) + SphericalDistanceLibrary.p2(FastMath.cos((double)lat1) * FastMath.sin((double)lat2) - FastMath.sin((double)lat1) * FastMath.cos((double)lat2) * FastMath.cos((double)deltaLon))));
        double x = FastMath.sin((double)lat1) * FastMath.sin((double)lat2) + FastMath.cos((double)lat1) * FastMath.cos((double)lat2) * FastMath.cos((double)deltaLon);
        return radius * FastMath.atan2((double)y, (double)x);
    }

    public static final double fastDistance(double lat1, double lon1, double lat2, double lon2, double radius) {
        if (FastMath.abs((double)(lat1 - lat2)) > 4.0 || FastMath.abs((double)(lon1 - lon2)) > 4.0) {
            return SphericalDistanceLibrary.distance(lat1, lon1, lat2, lon2, radius);
        }
        double dLat = FastMath.toRadians((double)(lat2 - lat1));
        double dLon = FastMath.toRadians((double)(lon2 - lon1)) * FastMath.cos((double)FastMath.toRadians((double)((lat1 + lat2) / 2.0)));
        return radius * FastMath.sqrt((double)(dLat * dLat + dLon * dLon)) * 0.999462;
    }

    private static final double p2(double a) {
        return a * a;
    }

    public static double metersToDegrees(double distanceMeters) {
        return 360.0 * distanceMeters / 4.003023642389422E7;
    }

    public static double degreesLatitudeToMeters(double degreesLatitude) {
        return 4.003023642389422E7 * degreesLatitude / 360.0;
    }

    public static double metersToLonDegrees(double distanceMeters, double latDeg) {
        double dLatDeg = 360.0 * distanceMeters / 4.003023642389422E7;
        double minCosLat = latDeg > 0.0 ? FastMath.cos((double)FastMath.toRadians((double)(latDeg + dLatDeg))) : FastMath.cos((double)FastMath.toRadians((double)(latDeg - dLatDeg)));
        return dLatDeg / minCosLat;
    }

    public static final Envelope bounds(double lat, double lon, double latDistance, double lonDistance) {
        double radiusOfEarth = 6371010.0;
        double latRadians = FastMath.toRadians((double)lat);
        double lonRadians = FastMath.toRadians((double)lon);
        double latRadius = radiusOfEarth;
        double lonRadius = FastMath.cos((double)latRadians) * radiusOfEarth;
        double latOffset = latDistance / latRadius;
        double lonOffset = lonDistance / lonRadius;
        double latFrom = FastMath.toDegrees((double)(latRadians - latOffset));
        double latTo = FastMath.toDegrees((double)(latRadians + latOffset));
        double lonFrom = FastMath.toDegrees((double)(lonRadians - lonOffset));
        double lonTo = FastMath.toDegrees((double)(lonRadians + lonOffset));
        return new Envelope(new Coordinate(lonFrom, latFrom), new Coordinate(lonTo, latTo));
    }
}

