/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common.geometry;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.algorithm.CGAlgorithms;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecursiveGridIsolineBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RecursiveGridIsolineBuilder.class);
    private static final int SIZE_0 = 4;
    private ZFunc fz;
    private int fzInterpolateCount;
    private double dX;
    private double dY;
    private Coordinate center;
    private Map<XYIndex, GridDot> allDots;
    private Set<GridDot> initialDots;
    private List<GridEdge> initialEdges;
    private boolean debugSeedGrid = false;
    private boolean debugCrossingEdges = false;
    private Geometry debugGeometry = null;

    public RecursiveGridIsolineBuilder(double dX, double dY, Coordinate center, ZFunc fz, List<Coordinate> p0List) {
        this.dX = dX;
        this.dY = dY;
        this.center = center;
        LOG.debug("Center={} dX={} dY={}", new Object[]{this.center, dX, dY});
        this.fz = fz;
        this.allDots = new HashMap<XYIndex, GridDot>(p0List.size() / 2);
        this.initialDots = new HashSet<GridDot>(p0List.size() / 2);
        for (Coordinate p0 : p0List) {
            XYIndex index0 = this.getIndex(p0, 4);
            for (int dx = -4; dx <= 4; dx += 4) {
                for (int dy = -4; dy <= 4; dy += 4) {
                    GridDot A = this.getOrCreateDot(index0.translated(dx, dy));
                    this.initialDots.add(A);
                }
            }
        }
        this.initialEdges = new ArrayList<GridEdge>(this.initialDots.size());
        for (GridDot A : this.initialDots) {
            GridEdge e;
            GridDot B = this.allDots.get(A.index.translated(4, 0));
            if (B != null) {
                e = new GridEdge(A, B, 4, true);
                this.initialEdges.add(e);
            }
            if ((B = this.allDots.get(A.index.translated(0, 4))) == null) continue;
            e = new GridEdge(A, B, 4, false);
            this.initialEdges.add(e);
        }
        LOG.debug("Created {} dots and {} edges out of {} initial points.", new Object[]{this.initialDots.size(), this.initialEdges.size(), p0List.size()});
    }

    public void setDebugSeedGrid(boolean debugSeedGrid) {
        this.debugSeedGrid = debugSeedGrid;
    }

    public void setDebugCrossingEdges(boolean debugCrossingEdges) {
        this.debugCrossingEdges = debugCrossingEdges;
    }

    public Geometry computeIsoline(long z0) {
        Coordinate B;
        Coordinate A;
        this.fzInterpolateCount = 0;
        GeometryFactory geomFactory = new GeometryFactory();
        ArrayDeque<GridEdge> edgesToDivide = new ArrayDeque<GridEdge>();
        edgesToDivide.addAll(this.initialEdges);
        ArrayDeque<GridEdge> edgesToExpand = new ArrayDeque<GridEdge>();
        while (!edgesToDivide.isEmpty()) {
            GridEdge gridEdge;
            GridEdge e = (GridEdge)edgesToDivide.remove();
            if (e.cut(z0) == 0) continue;
            int size2 = e.size / 2;
            XYIndex iC = e.horizontal ? e.A.index.translated(size2, 0) : e.A.index.translated(0, size2);
            GridDot gridDot = this.getOrCreateDot(iC);
            GridEdge e1 = new GridEdge(e.A, gridDot, size2, e.horizontal);
            GridEdge e2 = new GridEdge(gridDot, e.B, size2, e.horizontal);
            GridEdge gridEdge2 = gridEdge = e1.cut(z0) != 0 ? e1 : e2;
            if (gridEdge.cut(z0) == 0) {
                throw new AssertionError((Object)"Edge MUST cut!");
            }
            if (size2 == 1) {
                edgesToExpand.add(gridEdge);
                continue;
            }
            edgesToDivide.add(gridEdge);
        }
        HashSet finalEdges = new HashSet();
        HashSet<GridEdge> finalNonCuttingEdges = new HashSet<GridEdge>();
        while (!edgesToExpand.isEmpty()) {
            GridEdge[] e2List;
            GridEdge e = (GridEdge)edgesToExpand.remove();
            if (!finalEdges.add(e)) continue;
            XYIndex xYIndex = e.horizontal ? e.A.index.translated(0, 1) : e.A.index.translated(-1, 0);
            XYIndex iD = e.horizontal ? e.B.index.translated(0, 1) : e.B.index.translated(-1, 0);
            XYIndex iE = e.horizontal ? e.A.index.translated(0, -1) : e.A.index.translated(1, 0);
            XYIndex xYIndex2 = e.horizontal ? e.B.index.translated(0, -1) : e.B.index.translated(1, 0);
            GridDot C = this.getOrCreateDot(xYIndex);
            GridDot D = this.getOrCreateDot(iD);
            GridDot E = this.getOrCreateDot(iE);
            GridDot F = this.getOrCreateDot(xYIndex2);
            for (GridEdge e2 : e2List = new GridEdge[]{new GridEdge(e.A, C, 1, !e.horizontal), new GridEdge(C, D, 1, e.horizontal), new GridEdge(e.B, D, 1, !e.horizontal), new GridEdge(e.A, E, 1, !e.horizontal), new GridEdge(E, F, 1, e.horizontal), new GridEdge(e.B, F, 1, !e.horizontal)}) {
                if (e2.cut(z0) == 0) {
                    finalNonCuttingEdges.add(e2);
                    continue;
                }
                if (finalEdges.contains(e2)) continue;
                edgesToExpand.add(e2);
            }
        }
        for (GridEdge gridEdge : finalEdges) {
            gridEdge.indexEndPoints();
        }
        for (GridEdge gridEdge : finalNonCuttingEdges) {
            gridEdge.indexEndPoints();
        }
        int finalEdgesSize = finalEdges.size();
        int n = finalNonCuttingEdges.size();
        ArrayList<LineString> debugGeom = new ArrayList<LineString>();
        if (this.debugSeedGrid) {
            for (GridEdge gridEdge : this.initialEdges) {
                A = this.getCoordinate(gridEdge.A.index);
                B = this.getCoordinate(gridEdge.B.index);
                debugGeom.add(geomFactory.createLineString(new Coordinate[]{A, B}));
            }
        }
        if (this.debugCrossingEdges) {
            for (GridEdge gridEdge : finalEdges) {
                A = this.getCoordinate(gridEdge.A.index);
                B = this.getCoordinate(gridEdge.B.index);
                Coordinate C = this.interpolate(A, B, gridEdge.A.z, gridEdge.B.z, z0);
                Coordinate C1 = new Coordinate(C.x + (B.y - A.y) * 0.1, C.y + (B.x - A.x) * 0.1);
                Coordinate C2 = new Coordinate(C.x - (B.y - A.y) * 0.1, C.y - (B.x - A.x) * 0.1);
                debugGeom.add(geomFactory.createLineString(new Coordinate[]{A, C, C1, C2, C, B}));
            }
        }
        ArrayList<Polygon> retval = new ArrayList<Polygon>();
        ArrayList<LinearRing> arrayList = new ArrayList<LinearRing>();
        while (!finalEdges.isEmpty()) {
            GridEdge e0 = (GridEdge)finalEdges.iterator().next();
            ArrayList<Coordinate> polyPoints = new ArrayList<Coordinate>();
            int cut = e0.cut(z0);
            Direction direction = e0.horizontal ? (cut > 0 ? Direction.UP : Direction.DOWN) : (cut > 0 ? Direction.LEFT : Direction.RIGHT);
            GridEdge e = e0;
            while (true) {
                boolean ok3;
                GridEdge e3;
                Direction d2;
                GridEdge e2;
                Direction d1;
                GridEdge e1;
                Coordinate cA = this.getCoordinate(e.A.index);
                Coordinate cB = this.getCoordinate(e.B.index);
                Coordinate cC = this.interpolate(cA, cB, e.A.z, e.B.z, z0);
                polyPoints.add(cC);
                e.used = true;
                finalEdges.remove(e);
                switch (direction) {
                    default: {
                        e1 = e.A.up;
                        d1 = Direction.LEFT;
                        e2 = e.B.up;
                        d2 = Direction.RIGHT;
                        e3 = e1.B.right;
                        break;
                    }
                    case DOWN: {
                        e1 = e.A.down;
                        d1 = Direction.LEFT;
                        e2 = e.B.down;
                        d2 = Direction.RIGHT;
                        e3 = e1.A.right;
                        break;
                    }
                    case LEFT: {
                        e1 = e.A.left;
                        d1 = Direction.DOWN;
                        e2 = e.B.left;
                        d2 = Direction.UP;
                        e3 = e1.A.up;
                        break;
                    }
                    case RIGHT: {
                        e1 = e.A.right;
                        d1 = Direction.DOWN;
                        e2 = e.B.right;
                        d2 = Direction.UP;
                        e3 = e1.B.up;
                    }
                }
                boolean ok1 = e1.cut(z0) != 0 && !e1.used;
                boolean ok2 = e2.cut(z0) != 0 && !e2.used;
                boolean bl = ok3 = e3.cut(z0) != 0 && !e3.used;
                if (ok1 && ok2) {
                    double dB;
                    double dA = Math.max(Math.abs(cA.x - cC.x), Math.abs(cA.y - cC.y));
                    if (dA <= (dB = Math.max(Math.abs(cB.x - cC.x), Math.abs(cB.y - cC.y)))) {
                        e = e1;
                        direction = d1;
                        continue;
                    }
                    e = e2;
                    direction = d2;
                    continue;
                }
                if (ok1) {
                    e = e1;
                    direction = d1;
                    continue;
                }
                if (ok2) {
                    e = e2;
                    direction = d2;
                    continue;
                }
                if (!ok3) break;
                e = e3;
            }
            polyPoints.add((Coordinate)polyPoints.get(0));
            LinearRing ring = geomFactory.createLinearRing(polyPoints.toArray(new Coordinate[polyPoints.size()]));
            arrayList.add(ring);
        }
        retval.addAll(this.punchHoles(geomFactory, arrayList));
        LOG.info("Isochrones: {}+{} Fz samples, {} cutting edges, {} non-cutting edges", new Object[]{this.allDots.size(), this.fzInterpolateCount, finalEdgesSize, n});
        for (GridDot A2 : this.allDots.values()) {
            A2.left = null;
            A2.right = null;
            A2.down = null;
            A2.up = null;
        }
        this.debugGeometry = geomFactory.createGeometryCollection(debugGeom.toArray(new Geometry[debugGeom.size()]));
        return geomFactory.createGeometryCollection(retval.toArray(new Geometry[retval.size()]));
    }

    public final Geometry getDebugGeometry() {
        return this.debugGeometry;
    }

    private final XYIndex getIndex(Coordinate p, int size) {
        int xIndex = (int)Math.round((p.x - this.center.x) / this.dX);
        int yIndex = (int)Math.round((p.y - this.center.y) / this.dY);
        if (size != 1) {
            int size2 = size / 2;
            xIndex = (xIndex + (xIndex > 0 ? size2 : -size2)) / size * size;
            yIndex = (yIndex + (yIndex > 0 ? size2 : -size2)) / size * size;
        }
        return new XYIndex(xIndex, yIndex);
    }

    private final Coordinate getCoordinate(XYIndex index) {
        return new Coordinate((double)index.xIndex * this.dX + this.center.x, (double)index.yIndex * this.dY + this.center.y);
    }

    private GridDot getOrCreateDot(XYIndex xyIndex) {
        GridDot A = this.allDots.get(xyIndex);
        if (A == null) {
            A = new GridDot(xyIndex, this.fz.z(this.getCoordinate(xyIndex)));
            this.allDots.put(xyIndex, A);
        }
        return A;
    }

    private final Coordinate interpolate(Coordinate A, Coordinate B, long zA, long zB, long z0) {
        for (int n = 0; n < 3 && (zA == Long.MAX_VALUE || zB == Long.MAX_VALUE); ++n) {
            Coordinate C = new Coordinate((A.x + B.x) / 2.0, (A.y + B.y) / 2.0);
            long zC = this.fz.z(A);
            ++this.fzInterpolateCount;
            if (zA == Long.MAX_VALUE && z0 <= zC) {
                A = C;
                zA = zC;
                continue;
            }
            B = C;
            zB = zC;
        }
        if (zA == Long.MAX_VALUE) {
            zA = z0 * 2L;
        }
        if (zB == Long.MAX_VALUE) {
            zB = z0 * 2L;
        }
        double k = zB == zA ? 0.5 : (double)(z0 - zA) / (double)(zB - zA);
        Coordinate C = new Coordinate(A.x * (1.0 - k) + B.x * k, A.y * (1.0 - k) + B.y * k);
        return C;
    }

    private final List<Polygon> punchHoles(GeometryFactory geomFactory, List<LinearRing> rings) {
        ArrayList<Polygon> shells = new ArrayList<Polygon>(rings.size());
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>(rings.size() / 2);
        for (LinearRing ring : rings) {
            if (CGAlgorithms.signedArea((CoordinateSequence)ring.getCoordinateSequence()) > 0.0) {
                holes.add(ring);
                continue;
            }
            shells.add(geomFactory.createPolygon(ring));
        }
        Collections.sort(shells, new Comparator<Polygon>(){

            @Override
            public int compare(Polygon o1, Polygon o2) {
                return o2.getNumPoints() - o1.getNumPoints();
            }
        });
        for (Polygon shell : shells) {
            shell.setUserData(new ArrayList());
        }
        block2: for (LinearRing hole : holes) {
            for (Polygon shell : shells) {
                if (!shell.contains((Geometry)hole)) continue;
                ((List)shell.getUserData()).add(hole);
                continue block2;
            }
            LOG.error("Cannot find fitting shell for a hole!");
        }
        ArrayList<Polygon> punched = new ArrayList<Polygon>(shells.size());
        for (Polygon shell : shells) {
            List shellHoles = (List)shell.getUserData();
            punched.add(geomFactory.createPolygon(shell.getExteriorRing(), shellHoles.toArray(new LinearRing[shellHoles.size()])));
        }
        return punched;
    }

    private static class GridEdge {
        private GridDot A;
        private GridDot B;
        boolean horizontal;
        int size;
        boolean used = false;

        private GridEdge(GridDot A, GridDot B, int size, boolean horizontal) {
            if (horizontal && A.index.xIndex > B.index.xIndex || !horizontal && A.index.yIndex > B.index.yIndex) {
                this.A = B;
                this.B = A;
            } else {
                this.A = A;
                this.B = B;
            }
            this.size = size;
            this.horizontal = horizontal;
            if (horizontal) {
                if (this.A.index.yIndex != this.B.index.yIndex) {
                    throw new AssertionError((Object)"Building horizontal edge with non horizontally-aligned dots");
                }
                if (this.B.index.xIndex - this.A.index.xIndex != size) {
                    throw new AssertionError((Object)"Building horizontal edge with incorrect size vs dot spacing");
                }
            } else {
                if (this.A.index.xIndex != this.B.index.xIndex) {
                    throw new AssertionError((Object)"Building vertical edge with non vertically-aligned dots");
                }
                if (this.B.index.yIndex - this.A.index.yIndex != size) {
                    throw new AssertionError((Object)"Building vertical edge with incorrect size vs dot spacing");
                }
            }
        }

        private final void indexEndPoints() {
            if (this.size != 1) {
                throw new AssertionError((Object)"Can't dot-index edge with size != 1");
            }
            if (this.horizontal) {
                this.A.right = this;
                this.B.left = this;
            } else {
                this.A.up = this;
                this.B.down = this;
            }
        }

        private final int cut(long z0) {
            if (this.A.z < z0 && z0 <= this.B.z) {
                return 1;
            }
            if (this.B.z < z0 && z0 <= this.A.z) {
                return -1;
            }
            return 0;
        }

        public final int hashCode() {
            return this.A.hashCode() + this.size + (this.horizontal ? 32768 : 0);
        }

        public final boolean equals(Object other) {
            if (other instanceof GridEdge) {
                GridEdge otherEdge = (GridEdge)other;
                return this.A.equals(otherEdge.A) && this.size == otherEdge.size && this.horizontal == otherEdge.horizontal;
            }
            return false;
        }

        public final String toString() {
            return "[" + (this.horizontal ? "H" : "V") + "-Edge" + this.A + "-" + this.B + " L=" + this.size + "]";
        }
    }

    private static class GridDot {
        private XYIndex index;
        private long z;
        private GridEdge up;
        private GridEdge down;
        private GridEdge left;
        private GridEdge right;

        private GridDot(XYIndex index, long z) {
            this.index = index;
            this.z = z;
        }

        public final int hashCode() {
            return this.index.hashCode();
        }

        public final boolean equals(Object other) {
            if (other instanceof GridDot) {
                return this.index.equals(((GridDot)other).index);
            }
            return false;
        }

        public final String toString() {
            return "[Dot" + this.index + "," + this.z + "]";
        }
    }

    private static class XYIndex {
        private int xIndex;
        private int yIndex;

        private XYIndex(int xIndex, int yIndex) {
            this.xIndex = xIndex;
            this.yIndex = yIndex;
        }

        private final XYIndex translated(int dx, int dy) {
            return new XYIndex(this.xIndex + dx, this.yIndex + dy);
        }

        public final int hashCode() {
            return this.xIndex >> 16 | this.yIndex;
        }

        public final boolean equals(Object other) {
            if (other instanceof XYIndex) {
                XYIndex otherTileIndex = (XYIndex)other;
                return otherTileIndex.xIndex == this.xIndex && otherTileIndex.yIndex == this.yIndex;
            }
            return false;
        }

        public final String toString() {
            return "(" + this.xIndex + "," + this.yIndex + ")";
        }
    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }

    public static interface ZFunc {
        public long z(Coordinate var1);
    }
}

