/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common.geometry;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;

public abstract class PackedCoordinateSequence
implements CoordinateSequence,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected int dimension;
    protected transient SoftReference<Coordinate[]> coordRef;

    public int getDimension() {
        return this.dimension;
    }

    public Coordinate getCoordinate(int i) {
        Coordinate[] coords = this.getCachedCoords();
        if (coords != null) {
            return coords[i];
        }
        return this.getCoordinateInternal(i);
    }

    public Coordinate getCoordinateCopy(int i) {
        return this.getCoordinateInternal(i);
    }

    public void getCoordinate(int i, Coordinate coord) {
        coord.x = this.getOrdinate(i, 0);
        coord.y = this.getOrdinate(i, 1);
    }

    public Coordinate[] toCoordinateArray() {
        Coordinate[] coords = this.getCachedCoords();
        if (coords != null) {
            return coords;
        }
        coords = new Coordinate[this.size()];
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = this.getCoordinateInternal(i);
        }
        this.coordRef = new SoftReference<Coordinate[]>(coords);
        return coords;
    }

    private Coordinate[] getCachedCoords() {
        if (this.coordRef != null) {
            Coordinate[] coords = this.coordRef.get();
            if (coords != null) {
                return coords;
            }
            this.coordRef = null;
            return null;
        }
        return null;
    }

    public double getX(int index) {
        return this.getOrdinate(index, 0);
    }

    public double getY(int index) {
        return this.getOrdinate(index, 1);
    }

    public abstract double getOrdinate(int var1, int var2);

    public void setX(int index, double value) {
        this.coordRef = null;
        this.setOrdinate(index, 0, value);
    }

    public void setY(int index, double value) {
        this.coordRef = null;
        this.setOrdinate(index, 1, value);
    }

    protected abstract Coordinate getCoordinateInternal(int var1);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void setOrdinate(int var1, int var2, double var3);

    public String toString() {
        Object out = "";
        int n = Math.min(10, this.size());
        for (int i = 0; i < n; ++i) {
            Coordinate c = this.getCoordinate(i);
            out = (String)out + "(" + c.x + "," + c.y + ")";
        }
        return out;
    }

    public static class Float
    extends PackedCoordinateSequence {
        private static final long serialVersionUID = 1L;
        float[] coords;

        public Float(float[] coords, int dimensions) {
            if (dimensions < 2) {
                throw new IllegalArgumentException("Must have at least 2 dimensions");
            }
            if (coords.length % dimensions != 0) {
                throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
            }
            this.dimension = dimensions;
            this.coords = coords;
        }

        public Float(double[] coordinates, int dimensions) {
            this.coords = new float[coordinates.length];
            this.dimension = dimensions;
            for (int i = 0; i < coordinates.length; ++i) {
                this.coords[i] = (float)coordinates[i];
            }
        }

        public Float(Coordinate[] coordinates, int dimension) {
            if (coordinates == null) {
                coordinates = new Coordinate[]{};
            }
            this.dimension = dimension;
            this.coords = new float[coordinates.length * this.dimension];
            for (int i = 0; i < coordinates.length; ++i) {
                this.coords[i * this.dimension] = (float)coordinates[i].x;
                if (this.dimension >= 2) {
                    this.coords[i * this.dimension + 1] = (float)coordinates[i].y;
                }
                if (this.dimension < 3) continue;
                this.coords[i * this.dimension + 2] = (float)coordinates[i].z;
            }
        }

        public Float(int size, int dimension) {
            this.dimension = dimension;
            this.coords = new float[size * this.dimension];
        }

        @Override
        public Coordinate getCoordinateInternal(int i) {
            double x = this.coords[i * this.dimension];
            double y = this.coords[i * this.dimension + 1];
            double z = this.dimension == 2 ? 0.0 : (double)this.coords[i * this.dimension + 2];
            return new Coordinate(x, y, z);
        }

        public int size() {
            return this.coords.length / this.dimension;
        }

        @Override
        public Object clone() {
            Float clone = (Float)super.clone();
            clone.coords = (float[])this.coords.clone();
            return clone;
        }

        @Override
        public double getOrdinate(int index, int ordinate) {
            return this.coords[index * this.dimension + ordinate];
        }

        @Override
        public void setOrdinate(int index, int ordinate, double value) {
            this.coordRef = null;
            this.coords[index * this.dimension + ordinate] = (float)value;
        }

        public Envelope expandEnvelope(Envelope env) {
            for (int i = 0; i < this.coords.length; i += this.dimension) {
                env.expandToInclude((double)this.coords[i], (double)this.coords[i + 1]);
            }
            return env;
        }

        public CoordinateSequence copy() {
            Float clone = (Float)super.clone();
            clone.coords = (float[])this.coords.clone();
            return clone;
        }
    }

    public static class Double
    extends PackedCoordinateSequence {
        private static final long serialVersionUID = 1L;
        double[] coords;

        public Double(double[] coords, int dimensions) {
            if (dimensions < 2) {
                throw new IllegalArgumentException("Must have at least 2 dimensions");
            }
            if (coords.length % dimensions != 0) {
                throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
            }
            this.dimension = dimensions;
            this.coords = coords;
        }

        public Double(float[] coordinates, int dimensions) {
            this.coords = new double[coordinates.length];
            this.dimension = dimensions;
            for (int i = 0; i < coordinates.length; ++i) {
                this.coords[i] = coordinates[i];
            }
        }

        public Double(Coordinate[] coordinates, int dimension) {
            if (coordinates == null) {
                coordinates = new Coordinate[]{};
            }
            this.dimension = dimension;
            this.coords = new double[coordinates.length * this.dimension];
            for (int i = 0; i < coordinates.length; ++i) {
                this.coords[i * this.dimension] = coordinates[i].x;
                if (this.dimension >= 2) {
                    this.coords[i * this.dimension + 1] = coordinates[i].y;
                }
                if (this.dimension < 3) continue;
                this.coords[i * this.dimension + 2] = coordinates[i].z;
            }
        }

        public Double(Coordinate[] coordinates) {
            this(coordinates, 3);
        }

        public Double(int size, int dimension) {
            this.dimension = dimension;
            this.coords = new double[size * this.dimension];
        }

        @Override
        public Coordinate getCoordinateInternal(int i) {
            double x = this.coords[i * this.dimension];
            double y = this.coords[i * this.dimension + 1];
            double z = this.dimension == 2 ? 0.0 : this.coords[i * this.dimension + 2];
            return new Coordinate(x, y, z);
        }

        public int size() {
            return this.coords.length / this.dimension;
        }

        @Override
        public Object clone() {
            Double clone = (Double)super.clone();
            clone.coords = (double[])this.coords.clone();
            return clone;
        }

        @Override
        public double getOrdinate(int index, int ordinate) {
            return this.coords[index * this.dimension + ordinate];
        }

        @Override
        public void setOrdinate(int index, int ordinate, double value) {
            this.coordRef = null;
            this.coords[index * this.dimension + ordinate] = value;
        }

        public Envelope expandEnvelope(Envelope env) {
            for (int i = 0; i < this.coords.length; i += this.dimension) {
                env.expandToInclude(this.coords[i], this.coords[i + 1]);
            }
            return env;
        }

        public CoordinateSequence copy() {
            Double clone = (Double)super.clone();
            clone.coords = (double[])this.coords.clone();
            return clone;
        }
    }
}

