/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common.geometry;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class GeometryDeserializer
extends JsonDeserializer<Geometry> {
    private static GeometryFactory gf = new GeometryFactory();

    public Geometry deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectCodec oc = jp.getCodec();
        JsonNode root = (JsonNode)oc.readTree(jp);
        return GeometryDeserializer.parseGeometry(root);
    }

    public static Geometry parseGeometry(JsonNode root) {
        String typeName = root.get("type").asText();
        if (typeName.equals("Point")) {
            return gf.createPoint(GeometryDeserializer.parseCoordinate(root.get("coordinates")));
        }
        if (typeName.equals("MultiPoint")) {
            return gf.createMultiPoint(GeometryDeserializer.parseLineString(root.get("coordinates")));
        }
        if (typeName.equals("LineString")) {
            return gf.createLineString(GeometryDeserializer.parseLineString(root.get("coordinates")));
        }
        if (typeName.equals("MultiLineString")) {
            return gf.createMultiLineString(GeometryDeserializer.parseLineStrings(root.get("coordinates")));
        }
        if (typeName.equals("Polygon")) {
            JsonNode arrayOfRings = root.get("coordinates");
            return GeometryDeserializer.parsePolygonCoordinates(arrayOfRings);
        }
        if (typeName.equals("MultiPolygon")) {
            JsonNode arrayOfPolygons = root.get("coordinates");
            return gf.createMultiPolygon(GeometryDeserializer.parsePolygons(arrayOfPolygons));
        }
        if (typeName.equals("GeometryCollection")) {
            return gf.createGeometryCollection(GeometryDeserializer.parseGeometries(root.get("geometries")));
        }
        throw new UnsupportedOperationException();
    }

    private static Geometry[] parseGeometries(JsonNode arrayOfGeoms) {
        Geometry[] items = new Geometry[arrayOfGeoms.size()];
        for (int i = 0; i != arrayOfGeoms.size(); ++i) {
            items[i] = GeometryDeserializer.parseGeometry(arrayOfGeoms.get(i));
        }
        return items;
    }

    private static Polygon parsePolygonCoordinates(JsonNode arrayOfRings) {
        return gf.createPolygon(GeometryDeserializer.parseExteriorRing(arrayOfRings), GeometryDeserializer.parseInteriorRings(arrayOfRings));
    }

    private static Polygon[] parsePolygons(JsonNode arrayOfPolygons) {
        Polygon[] polygons = new Polygon[arrayOfPolygons.size()];
        for (int i = 0; i != arrayOfPolygons.size(); ++i) {
            polygons[i] = GeometryDeserializer.parsePolygonCoordinates(arrayOfPolygons.get(i));
        }
        return polygons;
    }

    private static LinearRing parseExteriorRing(JsonNode arrayOfRings) {
        return gf.createLinearRing(GeometryDeserializer.parseLineString(arrayOfRings.get(0)));
    }

    private static LinearRing[] parseInteriorRings(JsonNode arrayOfRings) {
        LinearRing[] rings = new LinearRing[arrayOfRings.size() - 1];
        for (int i = 1; i < arrayOfRings.size(); ++i) {
            rings[i - 1] = gf.createLinearRing(GeometryDeserializer.parseLineString(arrayOfRings.get(i)));
        }
        return rings;
    }

    private static Coordinate parseCoordinate(JsonNode array) {
        return new Coordinate(array.get(0).asDouble(), array.get(1).asDouble());
    }

    private static Coordinate[] parseLineString(JsonNode array) {
        Coordinate[] points = new Coordinate[array.size()];
        for (int i = 0; i != array.size(); ++i) {
            points[i] = GeometryDeserializer.parseCoordinate(array.get(i));
        }
        return points;
    }

    private static LineString[] parseLineStrings(JsonNode array) {
        LineString[] strings = new LineString[array.size()];
        for (int i = 0; i != array.size(); ++i) {
            strings[i] = gf.createLineString(GeometryDeserializer.parseLineString(array.get(i)));
        }
        return strings;
    }
}

