/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common.geometry;

import org.apache.commons.math3.util.FastMath;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;

public class DirectionUtils {
    public static DirectionUtils instance;

    private DirectionUtils() {
    }

    public static synchronized double getAzimuth(Coordinate a, Coordinate b) {
        double cosLat = FastMath.cos((double)FastMath.toRadians((double)((a.y + b.y) / 2.0)));
        double dY = b.y - a.y;
        double dX = (b.x - a.x) * cosLat;
        if (Math.abs(dX) < 1.0E-10 && Math.abs(dY) < 1.0E-10) {
            return 180.0;
        }
        double az = FastMath.toDegrees((double)FastMath.atan2((double)dX, (double)dY));
        return az;
    }

    public static synchronized double getLastAngle(Geometry geometry) {
        LineString line;
        if (geometry instanceof MultiLineString) {
            line = (LineString)geometry.getGeometryN(geometry.getNumGeometries() - 1);
        } else {
            assert (geometry instanceof LineString);
            line = (LineString)geometry;
        }
        int numPoints = line.getNumPoints();
        Coordinate coord0 = line.getCoordinateN(numPoints - 2);
        Coordinate coord1 = line.getCoordinateN(numPoints - 1);
        int i = numPoints - 3;
        int minDistance = 10;
        while (SphericalDistanceLibrary.fastDistance(coord0, coord1) < (double)minDistance && i >= 0) {
            coord0 = line.getCoordinateN(i--);
        }
        double az = DirectionUtils.getAzimuth(coord0, coord1);
        return az * Math.PI / 180.0;
    }

    public static synchronized double getFirstAngle(Geometry geometry) {
        LineString line;
        if (geometry instanceof MultiLineString) {
            line = (LineString)geometry.getGeometryN(0);
        } else {
            assert (geometry instanceof LineString);
            line = (LineString)geometry;
        }
        Coordinate coord0 = line.getCoordinateN(0);
        Coordinate coord1 = line.getCoordinateN(1);
        int i = 2;
        int minDistance = 10;
        while (SphericalDistanceLibrary.fastDistance(coord0, coord1) < (double)minDistance && i < line.getNumPoints()) {
            coord1 = line.getCoordinateN(i++);
        }
        double az = DirectionUtils.getAzimuth(coord0, coord1);
        return az * Math.PI / 180.0;
    }
}

