/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common.geometry;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.locationtech.jts.algorithm.CGAlgorithms;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.opentripplanner.common.geometry.DelaunayEdge;
import org.opentripplanner.common.geometry.DelaunayTriangulation;
import org.opentripplanner.common.geometry.IsolineBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelaunayIsolineBuilder<TZ>
implements IsolineBuilder<TZ> {
    private static final Logger LOG = LoggerFactory.getLogger(DelaunayIsolineBuilder.class);
    private IsolineBuilder.ZMetric<TZ> zMetric;
    private DelaunayTriangulation<TZ> triangulation;
    private boolean debug = false;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private List<Geometry> debugGeom = new ArrayList<Geometry>();

    public DelaunayIsolineBuilder(DelaunayTriangulation<TZ> triangulation, IsolineBuilder.ZMetric<TZ> zMetric) {
        this.triangulation = triangulation;
        this.zMetric = zMetric;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public Geometry computeIsoline(TZ z0) {
        ArrayDeque processQ = new ArrayDeque(this.triangulation.edgesCount());
        for (DelaunayEdge e : this.triangulation.edges()) {
            e.setProcessed(false);
            processQ.add(e);
        }
        if (this.debug) {
            this.generateDebugGeometry(z0);
        }
        ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
        while (!processQ.isEmpty()) {
            DelaunayEdge e;
            e = (DelaunayEdge)processQ.remove();
            if (e.isProcessed()) continue;
            e.setProcessed(true);
            int cut = this.zMetric.cut(e.getA().getZ(), e.getB().getZ(), z0);
            if (cut == 0) continue;
            ArrayList<Coordinate> polyPoints = new ArrayList<Coordinate>();
            boolean ccw = cut > 0;
            while (true) {
                boolean ok2;
                Coordinate cA = e.getA().getCoordinates();
                Coordinate cB = e.getB().getCoordinates();
                double k = this.zMetric.interpolate(e.getA().getZ(), e.getB().getZ(), z0);
                Coordinate cC = new Coordinate(cA.x * (1.0 - k) + cB.x * k, cA.y * (1.0 - k) + cB.y * k);
                polyPoints.add(cC);
                e.setProcessed(true);
                DelaunayEdge E1 = e.getEdge1(ccw);
                DelaunayEdge E2 = e.getEdge2(ccw);
                int cut1 = E1 == null ? 0 : this.zMetric.cut(E1.getA().getZ(), E1.getB().getZ(), z0);
                int cut2 = E2 == null ? 0 : this.zMetric.cut(E2.getA().getZ(), E2.getB().getZ(), z0);
                boolean ok1 = cut1 != 0 && !E1.isProcessed();
                boolean bl = ok2 = cut2 != 0 && !E2.isProcessed();
                if (ok1) {
                    e = E1;
                    ccw = cut1 > 0;
                    continue;
                }
                if (!ok2) break;
                e = E2;
                ccw = cut2 > 0;
            }
            polyPoints.add((Coordinate)polyPoints.get(0));
            if (polyPoints.size() <= 5) continue;
            LinearRing ring = this.geometryFactory.createLinearRing(polyPoints.toArray(new Coordinate[polyPoints.size()]));
            rings.add(ring);
        }
        List<Polygon> retval = this.punchHoles(rings);
        return this.geometryFactory.createGeometryCollection(retval.toArray(new Geometry[retval.size()]));
    }

    private final void generateDebugGeometry(TZ z0) {
        this.debug = false;
        for (DelaunayEdge<TZ> e : this.triangulation.edges()) {
            Coordinate cA = e.getA().getCoordinates();
            Coordinate cB = e.getB().getCoordinates();
            this.debugGeom.add((Geometry)this.geometryFactory.createLineString(new Coordinate[]{cA, cB}));
            if (this.zMetric.cut(e.getA().getZ(), e.getB().getZ(), z0) == 0) continue;
            double k = this.zMetric.interpolate(e.getA().getZ(), e.getB().getZ(), z0);
            Coordinate cC = new Coordinate(cA.x * (1.0 - k) + cB.x * k, cA.y * (1.0 - k) + cB.y * k);
            this.debugGeom.add((Geometry)this.geometryFactory.createPoint(cC));
        }
    }

    public final Geometry getDebugGeometry() {
        return this.geometryFactory.createGeometryCollection(this.debugGeom.toArray(new Geometry[this.debugGeom.size()]));
    }

    private final List<Polygon> punchHoles(List<LinearRing> rings) {
        ArrayList<Polygon> shells = new ArrayList<Polygon>(rings.size());
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>(rings.size() / 2);
        for (LinearRing linearRing : rings) {
            if (CGAlgorithms.signedArea((CoordinateSequence)linearRing.getCoordinateSequence()) > 0.0) {
                holes.add(linearRing);
                continue;
            }
            shells.add(this.geometryFactory.createPolygon(linearRing));
        }
        Collections.sort(shells, new Comparator<Polygon>(){

            @Override
            public int compare(Polygon o1, Polygon o2) {
                return o2.getNumPoints() - o1.getNumPoints();
            }
        });
        for (Polygon polygon : shells) {
            polygon.setUserData(new ArrayList());
        }
        int nHolesFailed = 0;
        block2: for (LinearRing hole : holes) {
            for (Polygon shell : shells) {
                if (!shell.contains((Geometry)hole)) continue;
                ((List)shell.getUserData()).add(hole);
                continue block2;
            }
            ++nHolesFailed;
        }
        if (nHolesFailed > 0) {
            LOG.error("Could not find a shell for {} holes.", (Object)nHolesFailed);
        }
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>(shells.size());
        for (Polygon shell : shells) {
            List shellHoles = (List)shell.getUserData();
            arrayList.add(this.geometryFactory.createPolygon(shell.getExteriorRing(), shellHoles.toArray(new LinearRing[shellHoles.size()])));
        }
        return arrayList;
    }
}

