/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common.geometry;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.DlugoszVarLenIntPacker;
import org.opentripplanner.common.geometry.GeometryUtils;

public final class CompactLineString {
    private static final double FIXED_FLOAT_MULT = 1000000.0;
    private static final double EPS = 1.0E-6;
    public static final byte[] STRAIGHT_LINE_PACKED = new byte[0];
    private static GeometryFactory geometryFactory = new GeometryFactory();

    public static byte[] compactLineString(double xa, double ya, double xb, double yb, LineString lineString, boolean reverse) {
        if (lineString == null) {
            return null;
        }
        if (lineString.getCoordinates().length == 2) {
            return STRAIGHT_LINE_PACKED;
        }
        double x0 = reverse ? xb : xa;
        double y0 = reverse ? yb : ya;
        double x1 = reverse ? xa : xb;
        double y1 = reverse ? ya : yb;
        Coordinate[] c = lineString.getCoordinates();
        if (Math.abs(x0 - c[0].x) > 1.0E-6 || Math.abs(y0 - c[0].y) > 1.0E-6 || Math.abs(x1 - c[c.length - 1].x) > 1.0E-6 || Math.abs(y1 - c[c.length - 1].y) > 1.0E-6) {
            throw new IllegalArgumentException("CompactLineString geometry must stick to given end points. If you need to relax this, please read source code.");
        }
        int oix = (int)Math.round(x0 * 1000000.0);
        int oiy = (int)Math.round(y0 * 1000000.0);
        int[] coords = new int[(c.length - 2) * 2];
        for (int i = 1; i < c.length - 1; ++i) {
            int ix = (int)Math.round(c[i].x * 1000000.0);
            int iy = (int)Math.round(c[i].y * 1000000.0);
            int dix = ix - oix;
            int diy = iy - oiy;
            coords[(i - 1) * 2] = dix;
            coords[(i - 1) * 2 + 1] = diy;
            oix = ix;
            oiy = iy;
        }
        return DlugoszVarLenIntPacker.pack(coords);
    }

    public static byte[] compactLineString(LineString lineString, boolean reverse) {
        if (lineString == null) {
            return null;
        }
        lineString = GeometryUtils.addStartEndCoordinatesToLineString(new Coordinate(0.0, 0.0), lineString, new Coordinate(0.0, 0.0));
        return CompactLineString.compactLineString(0.0, 0.0, 0.0, 0.0, lineString, reverse);
    }

    public static LineString uncompactLineString(double xa, double ya, double xb, double yb, byte[] packedCoords, boolean reverse) {
        int[] coords = DlugoszVarLenIntPacker.unpack(packedCoords);
        int size = coords == null ? 2 : coords.length / 2 + 2;
        Coordinate[] c = new Coordinate[size];
        double x0 = reverse ? xb : xa;
        double y0 = reverse ? yb : ya;
        double x1 = reverse ? xa : xb;
        double y1 = reverse ? ya : yb;
        c[0] = new Coordinate(x0, y0);
        if (coords != null) {
            int oix = (int)Math.round(x0 * 1000000.0);
            int oiy = (int)Math.round(y0 * 1000000.0);
            for (int i = 1; i < c.length - 1; ++i) {
                int ix = oix + coords[(i - 1) * 2];
                int iy = oiy + coords[(i - 1) * 2 + 1];
                c[i] = new Coordinate((double)ix / 1000000.0, (double)iy / 1000000.0);
                oix = ix;
                oiy = iy;
            }
        }
        c[c.length - 1] = new Coordinate(x1, y1);
        LineString out = geometryFactory.createLineString(c);
        if (reverse) {
            out = out.reverse();
        }
        return out;
    }

    public static LineString uncompactLineString(byte[] packedCoords, boolean reverse) {
        LineString lineString = CompactLineString.uncompactLineString(0.0, 0.0, 0.0, 0.0, packedCoords, reverse);
        return GeometryUtils.removeStartEndCoordinatesFromLineString(lineString);
    }
}

