/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common.geometry;

import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.opentripplanner.common.geometry.DlugoszVarLenIntPacker;
import org.opentripplanner.common.geometry.PackedCoordinateSequence;

public final class CompactElevationProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_DISTANCE_BETWEEN_SAMPLES_METERS = 10.0;
    private static final double FIXED_FLOAT_MULT = 100.0;
    private static double distanceBetweenSamplesM = 10.0;

    public static byte[] compactElevationProfileWithRegularSamples(CoordinateSequence elevation) {
        if (elevation == null) {
            return null;
        }
        int oiy = 0;
        int[] coords = new int[elevation.size()];
        for (int i = 0; i < elevation.size(); ++i) {
            int diy;
            Coordinate c = elevation.getCoordinate(i);
            int iy = (int)Math.round(c.y * 100.0);
            coords[i] = diy = iy - oiy;
            oiy = iy;
        }
        return DlugoszVarLenIntPacker.pack(coords);
    }

    public static PackedCoordinateSequence uncompactElevationProfileWithRegularSamples(byte[] packedCoords, double lengthM) {
        if (packedCoords == null) {
            return null;
        }
        int[] coords = DlugoszVarLenIntPacker.unpack(packedCoords);
        int size = coords.length;
        Coordinate[] c = new Coordinate[size];
        int oiy = 0;
        for (int i = 0; i < c.length; ++i) {
            int iy = oiy + coords[i];
            c[i] = new Coordinate(i == c.length - 1 ? lengthM : (double)i * distanceBetweenSamplesM, (double)iy / 100.0);
            oiy = iy;
        }
        return new PackedCoordinateSequence.Double(c, 2);
    }

    public static void setDistanceBetweenSamplesM(double distance) {
        distanceBetweenSamplesM = distance;
    }
}

