/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common;

import java.io.Serializable;
import java.util.Calendar;
import java.util.TimeZone;

public class RepeatingTimePeriod
implements Serializable {
    private static final long serialVersionUID = -5977328371879835782L;
    private int[][] monday;
    private int[][] tuesday;
    private int[][] wednesday;
    private int[][] thursday;
    private int[][] friday;
    private int[][] saturday;
    private int[][] sunday;
    private TimeZone timeZone = null;

    private RepeatingTimePeriod() {
    }

    public static RepeatingTimePeriod parseFromOsmTurnRestriction(String day_on, String day_off, String hour_on, String hour_off) {
        String[] parsedOff;
        String[] parsedOn = hour_on.split(";");
        if (parsedOn.length != (parsedOff = hour_off.split(";")).length) {
            return null;
        }
        int[][] onOff = new int[parsedOn.length][];
        for (int i = 0; i < parsedOn.length; ++i) {
            onOff[i] = new int[]{RepeatingTimePeriod.parseHour(parsedOn[i]), RepeatingTimePeriod.parseHour(parsedOff[i])};
        }
        boolean active = false;
        RepeatingTimePeriod ret = new RepeatingTimePeriod();
        for (String today : new String[]{"monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"}) {
            if (today.startsWith(day_on.toLowerCase())) {
                active = true;
            }
            if (active) {
                if (today == "monday") {
                    ret.monday = onOff;
                } else if (today == "tuesday") {
                    ret.tuesday = onOff;
                } else if (today == "wednesday") {
                    ret.wednesday = onOff;
                } else if (today == "thursday") {
                    ret.thursday = onOff;
                } else if (today == "friday") {
                    ret.friday = onOff;
                } else if (today == "saturday") {
                    ret.saturday = onOff;
                } else if (today == "sunday") {
                    ret.sunday = onOff;
                }
            }
            if (!today.startsWith(day_off.toLowerCase())) continue;
            active = false;
        }
        return ret;
    }

    private static int parseHour(String hour) {
        String[] parsed = hour.split(":");
        int ret = Integer.parseInt(parsed[0]) * 3600;
        if (parsed.length >= 2) {
            ret += Integer.parseInt(parsed[1]) * 60;
        }
        return ret -= 43200;
    }

    public boolean active(long time) {
        Calendar cal = this.timeZone != null ? Calendar.getInstance(TimeZone.getTimeZone("GMT")) : Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(time * 1000L);
        int dayOfWeek = cal.get(7);
        int[][] times = null;
        switch (dayOfWeek) {
            case 2: {
                times = this.monday;
                break;
            }
            case 3: {
                times = this.tuesday;
                break;
            }
            case 4: {
                times = this.wednesday;
                break;
            }
            case 5: {
                times = this.thursday;
                break;
            }
            case 6: {
                times = this.friday;
                break;
            }
            case 7: {
                times = this.saturday;
                break;
            }
            case 1: {
                times = this.sunday;
            }
        }
        if (times == null) {
            return false;
        }
        int timeOfDay = cal.get(11) * 3600 + cal.get(12) * 60 + cal.get(13) - 43200;
        for (int[] range : times) {
            if (timeOfDay < range[0] || timeOfDay > range[1]) continue;
            return true;
        }
        return false;
    }
}

