/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common;

import com.google.common.base.Strings;
import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.stream.IntStream;
import org.apache.commons.math3.random.MersenneTwister;

public class Histogram {
    private String title;
    private TIntIntMap bins = new TIntIntHashMap();
    private int maxBin = Integer.MIN_VALUE;
    private int minBin = Integer.MAX_VALUE;
    private long count = 0L;
    private int maxVal;

    public Histogram(String title) {
        this.title = title;
    }

    public void add(int i) {
        ++this.count;
        int binVal = this.bins.adjustOrPutValue(i, 1, 1);
        if (binVal > this.maxVal) {
            this.maxVal = binVal;
        }
        if (i > this.maxBin) {
            this.maxBin = i;
        }
        if (i < this.minBin) {
            this.minBin = i;
        }
    }

    private static String makeBar(int value, int max) {
        int WIDTH = 20;
        int n = value * 20 / max;
        String bar = Strings.repeat((String)"#", (int)n);
        String space = Strings.repeat((String)"_", (int)(20 - n));
        return bar + space + "  ";
    }

    public void display() {
        int i;
        int[] lessEqual = new int[this.maxBin + 1];
        System.out.println("--- Histogram: " + this.title + " ---");
        System.out.println(" n       ==      <=       >");
        int sum = 0;
        int maxCount = 0;
        for (i = this.minBin; i <= this.maxBin; ++i) {
            int n = this.bins.get(i);
            if (n > maxCount) {
                maxCount = n;
            }
            lessEqual[i] = sum += n;
        }
        for (i = 0; i <= this.maxBin; ++i) {
            if ((double)lessEqual[i] / (double)sum > 0.999) {
                System.out.println("Ending display at 99.9% of total objects.");
                break;
            }
            System.out.printf("%2d: %7d %7d %7d ", i, this.bins.get(i), lessEqual[i], sum - lessEqual[i]);
            System.out.print(Histogram.makeBar(this.bins.get(i), maxCount));
            System.out.print(Histogram.makeBar(lessEqual[i], sum));
            System.out.print(Histogram.makeBar(sum - lessEqual[i], sum));
            System.out.println();
        }
        System.out.println();
    }

    public void displayHorizontal() {
        System.out.println("--- Histogram: " + this.title + " ---");
        double vscale = 30.0 / (double)this.maxVal;
        for (int i = 0; i < 30; ++i) {
            StringBuilder row = new StringBuilder(this.maxBin - this.minBin + 1);
            int minValToDisplayThisRow = (int)((double)(30 - i) / vscale);
            for (int j = this.minBin; j <= this.maxBin; ++j) {
                if (this.bins.get(j) > minValToDisplayThisRow) {
                    row.append('#');
                    continue;
                }
                row.append(' ');
            }
            System.out.println(row);
        }
        if (this.minBin < 0 && this.maxBin > 0) {
            StringBuilder ticks = new StringBuilder();
            for (int i = this.minBin; i < 0; ++i) {
                ticks.append(' ');
            }
            ticks.append('|');
            System.out.println(ticks);
        }
        StringBuilder row = new StringBuilder();
        for (int i = this.minBin; i < this.maxBin; ++i) {
            row.append(' ');
        }
        String start = new Integer(this.minBin).toString();
        row.replace(0, start.length(), start);
        String end = new Integer(this.maxBin).toString();
        row.replace(row.length() - end.length(), row.length(), end);
        System.out.println(row);
    }

    public int mean() {
        long sum = 0L;
        TIntIntIterator it = this.bins.iterator();
        while (it.hasNext()) {
            it.advance();
            sum += (long)(it.key() * it.value());
        }
        return (int)(sum / this.count);
    }

    public static void main(String ... args) {
        System.out.println("Testing histogram store with normal distribution, mean 0");
        Histogram h = new Histogram("Normal");
        MersenneTwister mt = new MersenneTwister();
        IntStream.range(0, 1000000).map(i -> (int)Math.round(mt.nextGaussian() * 20.0 + 2.5)).forEach(h::add);
        h.displayHorizontal();
        System.out.println("mean: " + h.mean());
    }
}

