/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.opentripplanner.standalone.server.OTPServer;
import org.opentripplanner.standalone.server.Router;
import org.opentripplanner.updater.GraphUpdater;
import org.opentripplanner.updater.GraphUpdaterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/routers/{ignoreRouterId}/updaters")
@Produces(value={"application/json"})
public class UpdaterStatusResource {
    private static final Logger LOG = LoggerFactory.getLogger(UpdaterStatusResource.class);
    @QueryParam(value="detail")
    private boolean detail = false;
    @Deprecated
    @PathParam(value="ignoreRouterId")
    private String ignoreRouterId;
    Router router;

    public UpdaterStatusResource(@Context OTPServer otpServer) {
        this.router = otpServer.getRouter();
    }

    @GET
    public Response getUpdaters() {
        GraphUpdaterManager updaterManager = this.router.graph.updaterManager;
        if (updaterManager == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No updaters running.").build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(updaterManager.getUpdaterDescriptions()).build();
    }

    @GET
    @Path(value="/{updaterId}")
    public Response getUpdaters(@PathParam(value="updaterId") int updaterId) {
        GraphUpdaterManager updaterManager = this.router.graph.updaterManager;
        if (updaterManager == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No updaters running.").build();
        }
        GraphUpdater updater = updaterManager.getUpdater(updaterId);
        if (updater == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No updater with that ID.").build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(updater.getClass()).build();
    }
}

