/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import javax.annotation.security.PermitAll;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.opentripplanner.api.model.ApiRouterInfo;
import org.opentripplanner.api.model.ApiRouterList;
import org.opentripplanner.routing.error.GraphNotFoundException;
import org.opentripplanner.standalone.server.OTPServer;
import org.opentripplanner.standalone.server.Router;

@Path(value="/routers")
@PermitAll
public class Routers {
    @Context
    protected OTPServer otpServer;

    @GET
    @Path(value="{ignoreRouterId}")
    @Produces(value={"application/json"})
    public ApiRouterInfo getGraphId(@PathParam(value="ignoreRouterId") String ignore) {
        return this.getRouterInfo();
    }

    @GET
    @Produces(value={"application/json"})
    public ApiRouterList getRouterIds() {
        ApiRouterList routerList = new ApiRouterList();
        routerList.routerInfo.add(this.getRouterInfo());
        return routerList;
    }

    private ApiRouterInfo getRouterInfo() {
        try {
            Router router = this.otpServer.getRouter();
            return new ApiRouterInfo("default", router.graph);
        }
        catch (GraphNotFoundException e) {
            return null;
        }
    }
}

