/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.glassfish.grizzly.http.server.Request;
import org.opentripplanner.api.common.Message;
import org.opentripplanner.api.common.RoutingResource;
import org.opentripplanner.api.mapping.PlannerErrorMapper;
import org.opentripplanner.api.mapping.TripPlanMapper;
import org.opentripplanner.api.mapping.TripSearchMetadataMapper;
import org.opentripplanner.api.model.error.PlannerError;
import org.opentripplanner.api.resource.ElevationMetadata;
import org.opentripplanner.api.resource.TripPlannerResponse;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.standalone.server.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="routers/{ignoreRouterId}/plan")
public class PlannerResource
extends RoutingResource {
    private static final Logger LOG = LoggerFactory.getLogger(PlannerResource.class);
    @Deprecated
    @PathParam(value="ignoreRouterId")
    private String ignoreRouterId;

    @GET
    @Produces(value={"application/json"})
    public TripPlannerResponse plan(@Context UriInfo uriInfo, @Context Request grizzlyRequest) {
        TripPlannerResponse response = new TripPlannerResponse(uriInfo);
        RoutingRequest request = null;
        Router router = null;
        RoutingResponse res = null;
        try {
            request = super.buildRequest((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
            router = this.otpServer.getRouter();
            RoutingService routingService = new RoutingService(router.graph);
            res = routingService.route(request, router);
            TripPlanMapper tripPlanMapper = new TripPlanMapper(request.locale, request.showIntermediateStops);
            response.setPlan(tripPlanMapper.mapTripPlan(res.getTripPlan()));
            if (res.getPreviousPageCursor() != null) {
                response.setPreviousPageCursor(res.getPreviousPageCursor().encode());
            }
            if (res.getNextPageCursor() != null) {
                response.setNextPageCursor(res.getNextPageCursor().encode());
            }
            response.setMetadata(TripSearchMetadataMapper.mapTripSearchMetadata(res.getMetadata()));
            if (!res.getRoutingErrors().isEmpty()) {
                response.setError(PlannerErrorMapper.mapMessage(res.getRoutingErrors().get(0)));
            }
            response.elevationMetadata = new ElevationMetadata();
            response.elevationMetadata.ellipsoidToGeoidDifference = router.graph.ellipsoidToGeoidDifference;
            response.elevationMetadata.geoidElevation = request.geoidElevation;
            response.debugOutput = res.getDebugTimingAggregator().finishedRendering();
        }
        catch (Exception e) {
            LOG.error("System error", (Throwable)e);
            PlannerError error = new PlannerError(Message.SYSTEM_ERROR);
            response.setError(error);
        }
        this.logRequest(grizzlyRequest, request, router, res);
        return response;
    }

    private void logRequest(Request grizzlyRequest, RoutingRequest request, Router router, RoutingResponse res) {
        if (request != null && router != null && router.requestLogger != null) {
            StringBuilder sb = new StringBuilder();
            String clientIpAddress = grizzlyRequest.getRemoteAddr();
            sb.append(clientIpAddress);
            sb.append(' ');
            sb.append(request.arriveBy ? "ARRIVE" : "DEPART");
            sb.append(' ');
            sb.append(LocalDateTime.ofInstant(request.getDateTime(), ZoneId.systemDefault()));
            sb.append(' ');
            sb.append(request.streetSubRequestModes.getAsStr());
            sb.append(' ');
            sb.append(request.from.lat);
            sb.append(' ');
            sb.append(request.from.lng);
            sb.append(' ');
            sb.append(request.to.lat);
            sb.append(' ');
            sb.append(request.to.lng);
            sb.append(' ');
            if (res != null) {
                for (Itinerary it : res.getTripPlan().itineraries) {
                    sb.append(it.durationSeconds);
                    sb.append(' ');
                }
            }
            router.requestLogger.info(sb.toString());
        }
    }
}

