/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.geotools.geometry.Envelope2D;
import org.opentripplanner.api.parameter.MIMEImageFormat;
import org.opentripplanner.api.resource.InspectorLayersList;
import org.opentripplanner.common.geometry.MapTile;
import org.opentripplanner.common.geometry.WebMercatorTile;
import org.opentripplanner.standalone.server.OTPServer;
import org.opentripplanner.standalone.server.Router;

@Path(value="/routers/{ignoreRouterId}/inspector")
public class GraphInspectorTileResource {
    @Context
    private OTPServer otpServer;
    @Deprecated
    @PathParam(value="ignoreRouterId")
    private String ignoreRouterId;

    @GET
    @Path(value="/tile/{layer}/{z}/{x}/{y}.{ext}")
    @Produces(value={"image/*"})
    public Response tileGet(@PathParam(value="x") int x, @PathParam(value="y") int y, @PathParam(value="z") int z, @PathParam(value="layer") String layer, @PathParam(value="ext") String ext) throws Exception {
        Envelope2D env = WebMercatorTile.tile2Envelope(x, y, z);
        MapTile mapTile = new MapTile(env, 256, 256);
        Router router = this.otpServer.getRouter();
        BufferedImage image = router.tileRendererManager.renderTile(mapTile, layer);
        MIMEImageFormat format = new MIMEImageFormat("image/" + ext);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(image.getWidth() * image.getHeight() / 4);
        ImageIO.write((RenderedImage)image, format.type, baos);
        CacheControl cc = new CacheControl();
        cc.setMaxAge(3600);
        cc.setNoCache(false);
        return Response.ok((Object)baos.toByteArray()).type(format.toString()).cacheControl(cc).build();
    }

    @GET
    @Path(value="layers")
    @Produces(value={"application/json"})
    public InspectorLayersList getLayers() {
        Router router = this.otpServer.getRouter();
        InspectorLayersList layersList = new InspectorLayersList(router.tileRendererManager.getRenderers());
        return layersList;
    }
}

