/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import java.util.ArrayList;
import java.util.Arrays;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;

public class CoordinateArrayListSequence
implements CoordinateSequence,
Cloneable {
    ArrayList<Coordinate> coordinates;

    public CoordinateArrayListSequence() {
        this.coordinates = new ArrayList();
    }

    public CoordinateArrayListSequence(ArrayList<Coordinate> coordinates) {
        this.coordinates = (ArrayList)coordinates.clone();
    }

    public Envelope expandEnvelope(Envelope env) {
        for (Coordinate c : this.coordinates) {
            env.expandToInclude(c);
        }
        return env;
    }

    public CoordinateArrayListSequence clone() {
        CoordinateArrayListSequence clone;
        try {
            clone = (CoordinateArrayListSequence)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.coordinates = (ArrayList)this.coordinates.clone();
        return clone;
    }

    public Coordinate getCoordinate(int i) {
        return this.coordinates.get(i);
    }

    public void getCoordinate(int index, Coordinate coord) {
        Coordinate internalCoord = this.coordinates.get(index);
        coord.x = internalCoord.x;
        coord.y = internalCoord.y;
    }

    public Coordinate getCoordinateCopy(int i) {
        return new Coordinate(this.coordinates.get(i));
    }

    public int getDimension() {
        return 2;
    }

    public double getOrdinate(int index, int ordinateIndex) {
        return ordinateIndex == 0 ? this.coordinates.get((int)index).x : this.coordinates.get((int)index).y;
    }

    public double getX(int index) {
        return this.coordinates.get((int)index).x;
    }

    public double getY(int index) {
        return this.coordinates.get((int)index).y;
    }

    public void setOrdinate(int index, int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.coordinates.get((int)index).x = value;
                break;
            }
            case 1: {
                this.coordinates.get((int)index).y = value;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public int size() {
        return this.coordinates.size();
    }

    public Coordinate[] toCoordinateArray() {
        return this.coordinates.toArray(new Coordinate[0]);
    }

    public void extend(Coordinate[] newCoordinates) {
        this.coordinates.addAll(Arrays.asList(newCoordinates));
    }

    public void extend(Coordinate[] newCoordinates, int start) {
        this.extend(newCoordinates, start, newCoordinates.length);
    }

    public void extend(Coordinate[] newCoordinates, int start, int end) {
        this.coordinates.addAll(Arrays.asList(newCoordinates).subList(start, end));
    }

    public void add(Coordinate newCoordinate) {
        this.coordinates.add(newCoordinate);
    }

    public void clear() {
        this.coordinates = new ArrayList();
    }

    public CoordinateSequence copy() {
        CoordinateArrayListSequence clone;
        try {
            clone = (CoordinateArrayListSequence)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.coordinates = (ArrayList)this.coordinates.clone();
        return clone;
    }
}

