/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.api.mapping.VehicleRentalStationMapper;
import org.opentripplanner.api.model.ApiVehicleRentalStation;
import org.opentripplanner.api.model.ApiVehicleRentalStationList;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationService;
import org.opentripplanner.standalone.server.OTPServer;
import org.opentripplanner.standalone.server.Router;
import org.opentripplanner.util.ResourceBundleSingleton;

@Path(value="/routers/{ignoreRouterId}/bike_rental")
public class BikeRental {
    @Deprecated
    @PathParam(value="ignoreRouterId")
    private String ignoreRouterId;
    @Context
    OTPServer otpServer;

    @GET
    @Produces(value={"application/json"})
    public ApiVehicleRentalStationList getBikeRentalStations(@QueryParam(value="lowerLeft") String lowerLeft, @QueryParam(value="upperRight") String upperRight, @QueryParam(value="locale") String locale_param) {
        Router router = this.otpServer.getRouter();
        VehicleRentalStationService vehicleRentalService = router.graph.getService(VehicleRentalStationService.class);
        Locale locale = ResourceBundleSingleton.INSTANCE.getLocale(locale_param);
        if (vehicleRentalService == null) {
            return new ApiVehicleRentalStationList();
        }
        Envelope envelope = lowerLeft != null ? BikeRental.getEnvelope(lowerLeft, upperRight) : new Envelope(-180.0, 180.0, -90.0, 90.0);
        Collection<VehicleRentalPlace> stations = vehicleRentalService.getVehicleRentalPlaces();
        ArrayList<ApiVehicleRentalStation> out = new ArrayList<ApiVehicleRentalStation>();
        for (VehicleRentalPlace station : stations) {
            if (!envelope.contains(station.getLongitude(), station.getLatitude())) continue;
            out.add(VehicleRentalStationMapper.mapToApi(station, locale));
        }
        ApiVehicleRentalStationList brsl = new ApiVehicleRentalStationList();
        brsl.stations = out;
        return brsl;
    }

    public static Envelope getEnvelope(String lowerLeft, String upperRight) {
        String[] lowerLeftParts = lowerLeft.split(",");
        String[] upperRightParts = upperRight.split(",");
        Envelope envelope = new Envelope(Double.parseDouble(lowerLeftParts[1]), Double.parseDouble(upperRightParts[1]), Double.parseDouble(lowerLeftParts[0]), Double.parseDouble(upperRightParts[0]));
        return envelope;
    }
}

