/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.parameter;

import com.beust.jcommander.internal.Sets;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opentripplanner.api.parameter.ApiRequestMode;
import org.opentripplanner.api.parameter.QualifiedMode;
import org.opentripplanner.api.parameter.Qualifier;
import org.opentripplanner.model.modes.AllowedTransitMode;
import org.opentripplanner.routing.api.request.RequestModes;
import org.opentripplanner.routing.api.request.StreetMode;

public class QualifiedModeSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Set<QualifiedMode> qModes = Sets.newHashSet();

    public QualifiedModeSet(String s) {
        for (String qMode : s.split(",")) {
            this.qModes.add(new QualifiedMode(qMode));
        }
    }

    public RequestModes getRequestModes() {
        StreetMode accessMode = null;
        StreetMode egressMode = null;
        StreetMode directMode = null;
        StreetMode transferMode = null;
        Set<AllowedTransitMode> transitModes = this.qModes.stream().flatMap(q -> q.mode.getTransitModes().stream()).collect(Collectors.toSet());
        QualifiedMode requestMode = null;
        List filteredModes = this.qModes.stream().filter(m -> m.mode == ApiRequestMode.WALK || m.mode == ApiRequestMode.BICYCLE || m.mode == ApiRequestMode.SCOOTER || m.mode == ApiRequestMode.CAR).collect(Collectors.toList());
        if (filteredModes.size() > 1) {
            List filteredModesWithoutWalk = filteredModes.stream().filter(Predicate.not(m -> m.mode == ApiRequestMode.WALK)).collect(Collectors.toList());
            if (filteredModesWithoutWalk.size() > 1) {
                throw new IllegalStateException("Multiple non-walk modes provided " + filteredModesWithoutWalk);
            }
            requestMode = filteredModesWithoutWalk.isEmpty() ? (QualifiedMode)filteredModes.get(0) : (QualifiedMode)filteredModesWithoutWalk.get(0);
        } else if (!filteredModes.isEmpty()) {
            requestMode = (QualifiedMode)filteredModes.get(0);
        }
        if (requestMode != null) {
            switch (requestMode.mode) {
                case WALK: {
                    accessMode = StreetMode.WALK;
                    transferMode = StreetMode.WALK;
                    egressMode = StreetMode.WALK;
                    directMode = StreetMode.WALK;
                    break;
                }
                case BICYCLE: {
                    if (requestMode.qualifiers.contains((Object)Qualifier.RENT)) {
                        accessMode = StreetMode.BIKE_RENTAL;
                        transferMode = StreetMode.BIKE_RENTAL;
                        egressMode = StreetMode.BIKE_RENTAL;
                        directMode = StreetMode.BIKE_RENTAL;
                        break;
                    }
                    if (requestMode.qualifiers.contains((Object)Qualifier.PARK)) {
                        accessMode = StreetMode.BIKE_TO_PARK;
                        transferMode = StreetMode.WALK;
                        egressMode = StreetMode.WALK;
                        directMode = StreetMode.BIKE_TO_PARK;
                        break;
                    }
                    accessMode = StreetMode.BIKE;
                    transferMode = StreetMode.BIKE;
                    egressMode = StreetMode.BIKE;
                    directMode = StreetMode.BIKE;
                    break;
                }
                case SCOOTER: {
                    if (requestMode.qualifiers.contains((Object)Qualifier.RENT)) {
                        accessMode = StreetMode.SCOOTER_RENTAL;
                        transferMode = StreetMode.SCOOTER_RENTAL;
                        egressMode = StreetMode.SCOOTER_RENTAL;
                        directMode = StreetMode.SCOOTER_RENTAL;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case CAR: {
                    if (requestMode.qualifiers.contains((Object)Qualifier.RENT)) {
                        accessMode = StreetMode.CAR_RENTAL;
                        transferMode = StreetMode.CAR_RENTAL;
                        egressMode = StreetMode.CAR_RENTAL;
                        directMode = StreetMode.CAR_RENTAL;
                        break;
                    }
                    if (requestMode.qualifiers.contains((Object)Qualifier.PARK)) {
                        accessMode = StreetMode.CAR_TO_PARK;
                        transferMode = StreetMode.WALK;
                        egressMode = StreetMode.WALK;
                        directMode = StreetMode.CAR_TO_PARK;
                        break;
                    }
                    if (requestMode.qualifiers.contains((Object)Qualifier.PICKUP)) {
                        accessMode = StreetMode.WALK;
                        transferMode = StreetMode.WALK;
                        egressMode = StreetMode.CAR_PICKUP;
                        directMode = StreetMode.CAR_PICKUP;
                        break;
                    }
                    if (requestMode.qualifiers.contains((Object)Qualifier.DROPOFF)) {
                        accessMode = StreetMode.CAR_PICKUP;
                        transferMode = StreetMode.WALK;
                        egressMode = StreetMode.WALK;
                        directMode = StreetMode.CAR_PICKUP;
                        break;
                    }
                    accessMode = StreetMode.WALK;
                    transferMode = StreetMode.WALK;
                    egressMode = StreetMode.WALK;
                    directMode = StreetMode.CAR;
                }
            }
        }
        for (QualifiedMode qMode : this.qModes) {
            if (!qMode.mode.equals((Object)ApiRequestMode.FLEX)) continue;
            if (qMode.qualifiers.contains((Object)Qualifier.ACCESS)) {
                accessMode = StreetMode.FLEXIBLE;
                continue;
            }
            if (qMode.qualifiers.contains((Object)Qualifier.EGRESS)) {
                egressMode = StreetMode.FLEXIBLE;
                continue;
            }
            if (!qMode.qualifiers.contains((Object)Qualifier.DIRECT)) continue;
            directMode = StreetMode.FLEXIBLE;
        }
        if (transferMode == null) {
            transferMode = StreetMode.WALK;
        }
        return new RequestModes(accessMode, transferMode, egressMode, directMode, transitModes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (QualifiedMode qm : this.qModes) {
            sb.append(qm.toString());
            sb.append(" ");
        }
        return sb.toString();
    }
}

