/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.parameter;

import javax.ws.rs.BadRequestException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class BoundingBox {
    double minLat;
    double minLon;
    double maxLat;
    double maxLon;

    public BoundingBox(String s) {
        String[] elements = s.split(",");
        if (elements.length != 4) {
            throw new BadRequestException("A bounding box must have four coordinates.");
        }
        try {
            this.minLat = Double.parseDouble(elements[0]);
            this.minLon = Double.parseDouble(elements[1]);
            this.maxLat = Double.parseDouble(elements[2]);
            this.maxLon = Double.parseDouble(elements[3]);
        }
        catch (NumberFormatException pe) {
            throw new BadRequestException("Unable to parse coordinate: " + pe.getMessage());
        }
    }

    public Coordinate lowerLeft() {
        return new Coordinate(this.minLon, this.minLat);
    }

    public Coordinate upperLeft() {
        return new Coordinate(this.minLon, this.maxLat);
    }

    public Coordinate lowerRight() {
        return new Coordinate(this.maxLon, this.minLat);
    }

    public Coordinate upperRight() {
        return new Coordinate(this.maxLon, this.maxLat);
    }

    public Envelope envelope() {
        return new Envelope(this.minLon, this.maxLon, this.minLat, this.maxLat);
    }
}

