/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.api.mapping.TraverseModeMapper;
import org.opentripplanner.common.geometry.GeometrySerializer;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingService;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationService;
import org.opentripplanner.util.TravelOption;
import org.opentripplanner.util.TravelOptionsMaker;
import org.opentripplanner.util.WorldEnvelope;

public class ApiRouterInfo {
    public String routerId;
    @JsonSerialize(using=GeometrySerializer.class)
    public Geometry polygon;
    public Date buildTime;
    public long transitServiceStarts;
    public long transitServiceEnds;
    public List<String> transitModes;
    private WorldEnvelope envelope;
    public double centerLatitude;
    public double centerLongitude;
    public boolean hasParkRide;
    public boolean hasBikeSharing;
    public final boolean hasBikePark;
    public final boolean hasCarPark;
    public final boolean hasVehicleParking;
    public List<TravelOption> travelOptions;

    public ApiRouterInfo(String routerId, Graph graph) {
        VehicleRentalStationService vehicleRentalService = graph.getService(VehicleRentalStationService.class, false);
        VehicleParkingService vehicleParkingService = graph.getService(VehicleParkingService.class, false);
        this.routerId = routerId;
        this.polygon = graph.getConvexHull();
        this.buildTime = graph.buildTime;
        this.transitServiceStarts = graph.getTransitServiceStarts();
        this.transitServiceEnds = graph.getTransitServiceEnds();
        this.transitModes = TraverseModeMapper.mapToApi(graph.getTransitModes());
        this.envelope = graph.getEnvelope();
        this.hasParkRide = graph.hasParkRide;
        this.hasBikeSharing = this.mapHasBikeSharing(vehicleRentalService);
        this.hasBikePark = this.mapHasBikePark(vehicleParkingService);
        this.hasCarPark = this.mapHasCarPark(vehicleParkingService);
        this.hasVehicleParking = this.mapHasVehicleParking(vehicleParkingService);
        this.travelOptions = TravelOptionsMaker.makeOptions(graph);
        this.addCenter(graph.getCenter());
    }

    public boolean mapHasBikeSharing(VehicleRentalStationService service) {
        if (service == null) {
            return false;
        }
        return service.getVehicleRentalPlaces().size() > 1;
    }

    public boolean mapHasBikePark(VehicleParkingService service) {
        if (service == null) {
            return false;
        }
        return service.getBikeParks().findAny().isPresent();
    }

    public boolean mapHasCarPark(VehicleParkingService service) {
        if (service == null) {
            return false;
        }
        return service.getCarParks().findAny().isPresent();
    }

    public boolean mapHasVehicleParking(VehicleParkingService service) {
        if (service == null) {
            return false;
        }
        return service.getVehicleParkings().findAny().isPresent();
    }

    public void addCenter(Optional<Coordinate> center) {
        if (center.isPresent()) {
            this.centerLongitude = center.get().x;
            this.centerLatitude = center.get().y;
        } else {
            this.centerLatitude = (this.getUpperRightLatitude() + this.getLowerLeftLatitude()) / 2.0;
            this.centerLongitude = (this.getUpperRightLongitude() + this.getLowerLeftLongitude()) / 2.0;
        }
    }

    public double getLowerLeftLatitude() {
        return this.envelope.getLowerLeftLatitude();
    }

    public double getLowerLeftLongitude() {
        return this.envelope.getLowerLeftLongitude();
    }

    public double getUpperRightLatitude() {
        return this.envelope.getUpperRightLatitude();
    }

    public double getUpperRightLongitude() {
        return this.envelope.getUpperRightLongitude();
    }
}

