/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.mapping;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.api.mapping.BikeAccessMapper;
import org.opentripplanner.api.mapping.FeedScopedIdMapper;
import org.opentripplanner.api.model.ApiTrip;
import org.opentripplanner.api.model.ApiTripShort;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Trip;

public class TripMapper {
    public static ApiTrip mapToApi(Trip obj) {
        if (obj == null) {
            return null;
        }
        ApiTrip api = new ApiTrip();
        api.id = FeedScopedIdMapper.mapToApi(obj.getId());
        api.routeId = FeedScopedIdMapper.mapIdToApi(obj.getRoute());
        api.serviceId = FeedScopedIdMapper.mapToApi(obj.getServiceId());
        api.tripShortName = obj.getTripShortName();
        api.tripHeadsign = obj.getTripHeadsign();
        api.routeShortName = obj.getRouteShortName();
        api.directionId = obj.getGtfsDirectionIdAsString(null);
        api.blockId = obj.getBlockId();
        api.shapeId = FeedScopedIdMapper.mapToApi(obj.getShapeId());
        api.wheelchairAccessible = obj.getWheelchairAccessible();
        api.bikesAllowed = BikeAccessMapper.mapToApi(obj.getBikesAllowed());
        api.fareId = obj.getFareId();
        return api;
    }

    public static ApiTripShort mapToApiShort(Trip domain) {
        if (domain == null) {
            return null;
        }
        ApiTripShort api = new ApiTripShort();
        api.id = FeedScopedIdMapper.mapToApi(domain.getId());
        api.tripHeadsign = domain.getTripHeadsign();
        api.serviceId = FeedScopedIdMapper.mapToApi(domain.getServiceId());
        FeedScopedId shape = domain.getShapeId();
        api.shapeId = shape == null ? null : shape.getId();
        api.direction = domain.getDirection().gtfsCode;
        return api;
    }

    public static List<ApiTripShort> mapToApiShort(Stream<Trip> domain) {
        if (domain == null) {
            return null;
        }
        return domain.map(TripMapper::mapToApiShort).collect(Collectors.toList());
    }
}

