/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.mapping;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.api.mapping.AlertMapper;
import org.opentripplanner.api.mapping.BookingInfoMapper;
import org.opentripplanner.api.mapping.FeedScopedIdMapper;
import org.opentripplanner.api.mapping.PlaceMapper;
import org.opentripplanner.api.mapping.ServiceDateMapper;
import org.opentripplanner.api.mapping.StreetNoteMaperMapper;
import org.opentripplanner.api.mapping.TraverseModeMapper;
import org.opentripplanner.api.mapping.WalkStepMapper;
import org.opentripplanner.api.model.ApiAlert;
import org.opentripplanner.api.model.ApiLeg;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.util.PolylineEncoder;

public class LegMapper {
    private final WalkStepMapper walkStepMapper;
    private final StreetNoteMaperMapper streetNoteMaperMapper;
    private final AlertMapper alertMapper;
    private final PlaceMapper placeMapper;
    private final boolean addIntermediateStops;

    public LegMapper(Locale locale, boolean addIntermediateStops) {
        this.walkStepMapper = new WalkStepMapper(locale);
        this.streetNoteMaperMapper = new StreetNoteMaperMapper(locale);
        this.alertMapper = new AlertMapper(locale);
        this.placeMapper = new PlaceMapper(locale);
        this.addIntermediateStops = addIntermediateStops;
    }

    public List<ApiLeg> mapLegs(List<Leg> domain) {
        if (domain == null) {
            return null;
        }
        ArrayList<ApiLeg> apiLegs = new ArrayList<ApiLeg>();
        int size = domain.size();
        int lastIdx = size - 1;
        for (int i = 0; i < size; ++i) {
            Calendar arrivalTimeFromPlace = i == 0 ? null : domain.get(i - 1).getEndTime();
            Calendar departureTimeToPlace = i == lastIdx ? null : domain.get(i + 1).getStartTime();
            apiLegs.add(this.mapLeg(domain.get(i), arrivalTimeFromPlace, departureTimeToPlace));
        }
        return apiLegs;
    }

    public ApiLeg mapLeg(Leg domain, Calendar arrivalTimeFromPlace, Calendar departureTimeToPlace) {
        if (domain == null) {
            return null;
        }
        ApiLeg api = new ApiLeg();
        api.startTime = domain.getStartTime();
        api.endTime = domain.getEndTime();
        api.from = this.placeMapper.mapPlace(domain.getFrom(), arrivalTimeFromPlace, api.startTime, domain.getBoardStopPosInPattern(), domain.getBoardingGtfsStopSequence());
        api.to = this.placeMapper.mapPlace(domain.getTo(), api.endTime, departureTimeToPlace, domain.getAlightStopPosInPattern(), domain.getAlightGtfsStopSequence());
        api.departureDelay = domain.getDepartureDelay();
        api.arrivalDelay = domain.getArrivalDelay();
        api.realTime = domain.getRealTime();
        api.isNonExactFrequency = domain.getNonExactFrequency();
        api.headway = domain.getHeadway();
        api.distance = domain.getDistanceMeters();
        api.generalizedCost = domain.getGeneralizedCost();
        api.pathway = domain.getPathwayId() != null;
        api.mode = TraverseModeMapper.mapToApi(domain.getMode());
        api.agencyTimeZoneOffset = domain.getAgencyTimeZoneOffset();
        api.transitLeg = domain.isTransitLeg();
        if (domain.isTransitLeg()) {
            Agency agency = domain.getAgency();
            api.agencyId = FeedScopedIdMapper.mapToApi(agency.getId());
            api.agencyName = agency.getName();
            api.agencyUrl = agency.getUrl();
            api.agencyBrandingUrl = agency.getBrandingUrl();
            Route route = domain.getRoute();
            api.route = route.getLongName();
            api.routeColor = route.getColor();
            api.routeType = domain.getRouteType();
            api.routeId = FeedScopedIdMapper.mapToApi(route.getId());
            api.routeShortName = route.getShortName();
            api.routeLongName = route.getLongName();
            api.routeTextColor = route.getTextColor();
            Trip trip = domain.getTrip();
            api.tripId = FeedScopedIdMapper.mapToApi(trip.getId());
            api.tripShortName = trip.getTripShortName();
            api.tripBlockId = trip.getBlockId();
        } else {
            api.route = domain.getPathwayId() != null ? FeedScopedIdMapper.mapToApi(domain.getPathwayId()) : "";
        }
        api.interlineWithPreviousLeg = domain.isInterlinedWithPreviousLeg();
        api.headsign = domain.getHeadsign();
        api.serviceDate = ServiceDateMapper.mapToApi(domain.getServiceDate());
        api.routeBrandingUrl = domain.getRouteBrandingUrl();
        if (this.addIntermediateStops) {
            api.intermediateStops = this.placeMapper.mapStopArrivals(domain.getIntermediateStops());
        }
        api.legGeometry = PolylineEncoder.createEncodings((Geometry)domain.getLegGeometry());
        api.steps = this.walkStepMapper.mapWalkSteps(domain.getWalkSteps());
        api.alerts = LegMapper.concatenateAlerts(this.streetNoteMaperMapper.mapToApi(domain.getStreetNotes()), this.alertMapper.mapToApi(domain.getTransitAlerts()));
        api.boardRule = LegMapper.getBoardAlightMessage(domain.getBoardRule());
        api.alightRule = LegMapper.getBoardAlightMessage(domain.getAlightRule());
        api.pickupBookingInfo = BookingInfoMapper.mapBookingInfo(domain.getPickupBookingInfo(), true);
        api.dropOffBookingInfo = BookingInfoMapper.mapBookingInfo(domain.getDropOffBookingInfo(), false);
        api.rentedBike = domain.getRentedVehicle();
        api.walkingBike = domain.getWalkingBike();
        return api;
    }

    private static String getBoardAlightMessage(PickDrop boardAlightType) {
        if (boardAlightType == null) {
            return null;
        }
        switch (boardAlightType) {
            case NONE: {
                return "impossible";
            }
            case CALL_AGENCY: {
                return "mustPhone";
            }
            case COORDINATE_WITH_DRIVER: {
                return "coordinateWithDriver";
            }
        }
        return null;
    }

    private static List<ApiAlert> concatenateAlerts(List<ApiAlert> a, List<ApiAlert> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList<ApiAlert> ret = new ArrayList<ApiAlert>(a);
        ret.addAll(b);
        return ret;
    }
}

