/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionResult;
import graphql.execution.AbortExecutionException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLResponseSerializer {
    static final Logger LOG = LoggerFactory.getLogger(GraphQLResponseSerializer.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String serialize(ExecutionResult executionResult) {
        try {
            return objectMapper.writeValueAsString((Object)executionResult.toSpecification());
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to serialize response", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String serializeBatch(List<HashMap<String, Object>> queries, List<Future<ExecutionResult>> futures) {
        LinkedList<Map<String, Map>> responses = new LinkedList<Map<String, Map>>();
        for (int i = 0; i < queries.size(); ++i) {
            ExecutionResult executionResult;
            try {
                executionResult = futures.get(i).get();
            }
            catch (InterruptedException | ExecutionException e) {
                executionResult = new AbortExecutionException((Throwable)e).toExecutionResult();
            }
            responses.add(Map.of("id", queries.get(i).get("id"), "payload", executionResult.toSpecification()));
        }
        try {
            return objectMapper.writeValueAsString(responses);
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to serialize response", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

