/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.common;

import java.time.Duration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.opentripplanner.api.common.LocationStringParser;
import org.opentripplanner.api.common.ParameterException;
import org.opentripplanner.api.parameter.QualifiedModeSet;
import org.opentripplanner.ext.dataoverlay.api.DataOverlayParameters;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.plan.pagecursor.PageCursor;
import org.opentripplanner.routing.api.request.BannedStopSet;
import org.opentripplanner.routing.api.request.DebugRaptor;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.BicycleOptimizeType;
import org.opentripplanner.standalone.server.OTPServer;
import org.opentripplanner.standalone.server.Router;
import org.opentripplanner.util.OTPFeature;
import org.opentripplanner.util.ResourceBundleSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RoutingResource {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingResource.class);
    @QueryParam(value="fromPlace")
    protected String fromPlace;
    @QueryParam(value="toPlace")
    protected String toPlace;
    @Deprecated
    @QueryParam(value="intermediatePlaces")
    protected List<String> intermediatePlaces;
    @QueryParam(value="date")
    protected String date;
    @QueryParam(value="time")
    protected String time;
    @QueryParam(value="searchWindow")
    protected Integer searchWindow;
    @QueryParam(value="pageCursor")
    public String pageCursor;
    @QueryParam(value="timetableView")
    public Boolean timetableView;
    @Deprecated
    @QueryParam(value="arriveBy")
    protected Boolean arriveBy;
    @Deprecated
    @QueryParam(value="wheelchair")
    protected Boolean wheelchair;
    @Deprecated
    @QueryParam(value="maxWalkDistance")
    protected Double maxWalkDistance;
    @Deprecated
    @QueryParam(value="maxPreTransitTime")
    protected Integer maxPreTransitTime;
    @QueryParam(value="bikeWalkingReluctance")
    protected Double bikeWalkingReluctance;
    @QueryParam(value="walkReluctance")
    protected Double walkReluctance;
    @QueryParam(value="bikeReluctance")
    protected Double bikeReluctance;
    @QueryParam(value="carReluctance")
    protected Double carReluctance;
    @QueryParam(value="waitReluctance")
    protected Double waitReluctance;
    @QueryParam(value="waitAtBeginningFactor")
    protected Double waitAtBeginningFactor;
    @QueryParam(value="walkSpeed")
    protected Double walkSpeed;
    @QueryParam(value="bikeSpeed")
    protected Double bikeSpeed;
    @QueryParam(value="bikeWalkingSpeed")
    protected Double bikeWalkingSpeed;
    @QueryParam(value="bikeSwitchTime")
    protected Integer bikeSwitchTime;
    @QueryParam(value="bikeSwitchCost")
    protected Integer bikeSwitchCost;
    @QueryParam(value="triangleSafetyFactor")
    protected Double triangleSafetyFactor;
    @QueryParam(value="triangleSlopeFactor")
    protected Double triangleSlopeFactor;
    @QueryParam(value="triangleTimeFactor")
    protected Double triangleTimeFactor;
    @Deprecated
    @QueryParam(value="optimize")
    protected BicycleOptimizeType optimize;
    @QueryParam(value="mode")
    protected QualifiedModeSet modes;
    @Deprecated
    @QueryParam(value="minTransferTime")
    protected Integer minTransferTime;
    @QueryParam(value="numItineraries")
    protected Integer numItineraries;
    @Deprecated
    @QueryParam(value="preferredAgencies")
    protected String preferredAgencies;
    @Deprecated
    @QueryParam(value="unpreferredAgencies")
    protected String unpreferredAgencies;
    @QueryParam(value="bannedAgencies")
    protected String bannedAgencies;
    @QueryParam(value="whiteListedAgencies")
    protected String whiteListedAgencies;
    @QueryParam(value="showIntermediateStops")
    protected Boolean showIntermediateStops;
    @QueryParam(value="walkBoardCost")
    protected Integer walkBoardCost;
    @QueryParam(value="bikeBoardCost")
    protected Integer bikeBoardCost;
    @QueryParam(value="allowKeepingRentedBicycleAtDestination")
    protected Boolean allowKeepingRentedBicycleAtDestination;
    @QueryParam(value="keepingRentedBicycleAtDestinationCost")
    protected Double keepingRentedBicycleAtDestinationCost;
    @QueryParam(value="allowedVehicleRentalNetworks")
    protected Set<String> allowedVehicleRentalNetworks;
    @QueryParam(value="bannedVehicleRentalNetworks")
    protected Set<String> bannedVehicleRentalNetworks;
    @QueryParam(value="bikeParkTime")
    protected Integer bikeParkTime;
    @QueryParam(value="bikeParkCost")
    protected Integer bikeParkCost;
    @QueryParam(value="carParkTime")
    protected Integer carParkTime = 60;
    @QueryParam(value="carParkCost")
    protected Integer carParkCost = 120;
    @QueryParam(value="requiredVehicleParkingTags")
    protected Set<String> requiredVehicleParkingTags = Set.of();
    @QueryParam(value="bannedVehicleParkingTags")
    protected Set<String> bannedVehicleParkingTags = Set.of();
    @Deprecated
    @QueryParam(value="bannedRoutes")
    protected String bannedRoutes;
    @QueryParam(value="whiteListedRoutes")
    @Deprecated
    protected String whiteListedRoutes;
    @Deprecated
    @QueryParam(value="preferredRoutes")
    protected String preferredRoutes;
    @Deprecated
    @QueryParam(value="unpreferredRoutes")
    protected String unpreferredRoutes;
    @Deprecated
    @QueryParam(value="otherThanPreferredRoutesPenalty")
    protected Integer otherThanPreferredRoutesPenalty;
    @Deprecated
    @QueryParam(value="bannedTrips")
    protected String bannedTrips;
    @Deprecated
    @QueryParam(value="bannedStops")
    protected String bannedStops;
    @Deprecated
    @QueryParam(value="bannedStopsHard")
    protected String bannedStopsHard;
    @QueryParam(value="transferPenalty")
    protected Integer transferPenalty;
    @Deprecated
    @QueryParam(value="nonpreferredTransferPenalty")
    protected Integer nonpreferredTransferPenalty;
    @Deprecated
    @QueryParam(value="maxTransfers")
    protected Integer maxTransfers;
    @Deprecated
    @QueryParam(value="batch")
    protected Boolean batch;
    @Deprecated
    @QueryParam(value="startTransitStopId")
    protected String startTransitStopId;
    @Deprecated
    @QueryParam(value="startTransitTripId")
    protected String startTransitTripId;
    @Deprecated
    @QueryParam(value="clampInitialWait")
    protected Long clampInitialWait;
    @Deprecated
    @QueryParam(value="reverseOptimizeOnTheFly")
    protected Boolean reverseOptimizeOnTheFly;
    @QueryParam(value="boardSlack")
    private Integer boardSlack;
    @QueryParam(value="alightSlack")
    private Integer alightSlack;
    @QueryParam(value="locale")
    private String locale;
    @Deprecated
    @QueryParam(value="ignoreRealtimeUpdates")
    protected Boolean ignoreRealtimeUpdates;
    @QueryParam(value="disableRemainingWeightHeuristic")
    protected Boolean disableRemainingWeightHeuristic;
    @Deprecated
    @QueryParam(value="maxHours")
    private Double maxHours;
    @QueryParam(value="useRequestedDateTimeInMaxHours")
    @Deprecated
    private Boolean useRequestedDateTimeInMaxHours;
    @QueryParam(value="disableAlertFiltering")
    private Boolean disableAlertFiltering;
    @QueryParam(value="debugItineraryFilter")
    private Boolean debugItineraryFilter;
    @QueryParam(value="geoidElevation")
    private Boolean geoidElevation;
    @Deprecated
    @QueryParam(value="pathComparator")
    private String pathComparator;
    @QueryParam(value="useVehicleParkingAvailabilityInformation")
    private Boolean useVehicleParkingAvailabilityInformation;
    @QueryParam(value="debugRaptorStops")
    private String debugRaptorStops;
    @QueryParam(value="debugRaptorPath")
    private String debugRaptorPath;
    @Context
    protected OTPServer otpServer;

    protected RoutingRequest buildRequest(MultivaluedMap<String, String> queryParameters) throws ParameterException {
        DataOverlayParameters queryDataOverlayParameters;
        HashMap<FeedScopedId, BannedStopSet> bannedTripMap;
        Router router = this.otpServer.getRouter();
        RoutingRequest request = router.defaultRoutingRequest.clone();
        if (this.fromPlace != null) {
            request.from = LocationStringParser.fromOldStyleString(this.fromPlace);
        }
        if (this.toPlace != null) {
            request.to = LocationStringParser.fromOldStyleString(this.toPlace);
        }
        TimeZone tz = router.graph.getTimeZone();
        if (this.date == null && this.time != null) {
            LOG.debug("parsing ISO datetime {}", (Object)this.time);
            try {
                DatatypeFactory df = DatatypeFactory.newInstance();
                XMLGregorianCalendar xmlGregCal = df.newXMLGregorianCalendar(this.time);
                GregorianCalendar gregCal = xmlGregCal.toGregorianCalendar();
                if (xmlGregCal.getTimezone() == Integer.MIN_VALUE) {
                    gregCal.setTimeZone(tz);
                }
                request.setDateTime(gregCal.toInstant());
            }
            catch (DatatypeConfigurationException e) {
                request.setDateTime(this.date, this.time, tz);
            }
        } else {
            request.setDateTime(this.date, this.time, tz);
        }
        if (this.searchWindow != null) {
            request.searchWindow = Duration.ofSeconds(this.searchWindow.intValue());
        }
        if (this.pageCursor != null) {
            request.pageCursor = PageCursor.decode(this.pageCursor);
        }
        if (this.timetableView != null) {
            request.timetableView = this.timetableView;
        }
        if (this.wheelchair != null) {
            request.setWheelchairAccessible(this.wheelchair);
        }
        if (this.numItineraries != null) {
            request.setNumItineraries(this.numItineraries);
        }
        if (this.bikeReluctance != null) {
            request.setBikeReluctance(this.bikeReluctance);
        }
        if (this.bikeWalkingReluctance != null) {
            request.setBikeWalkingReluctance(this.bikeWalkingReluctance);
        }
        if (this.carReluctance != null) {
            request.setCarReluctance(this.carReluctance);
        }
        if (this.walkReluctance != null) {
            request.setWalkReluctance(this.walkReluctance);
        }
        if (this.waitReluctance != null) {
            request.setWaitReluctance(this.waitReluctance);
        }
        if (this.waitAtBeginningFactor != null) {
            request.setWaitAtBeginningFactor(this.waitAtBeginningFactor);
        }
        if (this.walkSpeed != null) {
            request.walkSpeed = this.walkSpeed;
        }
        if (this.bikeSpeed != null) {
            request.bikeSpeed = this.bikeSpeed;
        }
        if (this.bikeWalkingSpeed != null) {
            request.bikeWalkingSpeed = this.bikeWalkingSpeed;
        }
        if (this.bikeSwitchTime != null) {
            request.bikeSwitchTime = this.bikeSwitchTime;
        }
        if (this.bikeSwitchCost != null) {
            request.bikeSwitchCost = this.bikeSwitchCost;
        }
        if (this.allowKeepingRentedBicycleAtDestination != null) {
            request.allowKeepingRentedVehicleAtDestination = this.allowKeepingRentedBicycleAtDestination;
        }
        if (this.keepingRentedBicycleAtDestinationCost != null) {
            request.keepingRentedVehicleAtDestinationCost = this.keepingRentedBicycleAtDestinationCost;
        }
        if (this.allowedVehicleRentalNetworks != null) {
            request.allowedVehicleRentalNetworks = this.allowedVehicleRentalNetworks;
        }
        if (this.bannedVehicleRentalNetworks != null) {
            request.bannedVehicleRentalNetworks = this.bannedVehicleRentalNetworks;
        }
        if (this.bikeParkCost != null) {
            request.bikeParkCost = this.bikeParkCost;
        }
        if (this.bikeParkTime != null) {
            request.bikeParkTime = this.bikeParkTime;
        }
        if (this.carParkCost != null) {
            request.carParkCost = this.carParkCost;
        }
        if (this.carParkTime != null) {
            request.carParkTime = this.carParkTime;
        }
        if (this.bannedVehicleParkingTags != null) {
            request.bannedVehicleParkingTags = this.bannedVehicleParkingTags;
        }
        if (this.requiredVehicleParkingTags != null) {
            request.requiredVehicleParkingTags = this.requiredVehicleParkingTags;
        }
        if (this.optimize != null) {
            request.setBicycleOptimizeType(this.optimize);
            if (this.optimize == BicycleOptimizeType.TRIANGLE) {
                request.setTriangleNormalized(this.triangleSafetyFactor, this.triangleSlopeFactor, this.triangleTimeFactor);
            }
        }
        if (this.arriveBy != null) {
            request.setArriveBy(this.arriveBy);
        }
        if (this.showIntermediateStops != null) {
            request.showIntermediateStops = this.showIntermediateStops;
        }
        if (this.intermediatePlaces != null) {
            request.setIntermediatePlacesFromStrings(this.intermediatePlaces);
        }
        if (this.preferredRoutes != null) {
            request.setPreferredRoutesFromSting(this.preferredRoutes);
        }
        if (this.otherThanPreferredRoutesPenalty != null) {
            request.setOtherThanPreferredRoutesPenalty(this.otherThanPreferredRoutesPenalty);
        }
        if (this.preferredAgencies != null) {
            request.setPreferredAgenciesFromString(this.preferredAgencies);
        }
        if (this.unpreferredRoutes != null) {
            request.setUnpreferredRoutesFromSting(this.unpreferredRoutes);
        }
        if (this.unpreferredAgencies != null) {
            request.setUnpreferredAgenciesFromString(this.unpreferredAgencies);
        }
        if (this.walkBoardCost != null) {
            request.setWalkBoardCost(this.walkBoardCost);
        }
        if (this.bikeBoardCost != null) {
            request.setBikeBoardCost(this.bikeBoardCost);
        }
        if (this.bannedRoutes != null) {
            request.setBannedRoutesFromSting(this.bannedRoutes);
        }
        if (this.whiteListedRoutes != null) {
            request.setWhiteListedRoutesFromSting(this.whiteListedRoutes);
        }
        if (this.bannedAgencies != null) {
            request.setBannedAgenciesFromSting(this.bannedAgencies);
        }
        if (this.whiteListedAgencies != null) {
            request.setWhiteListedAgenciesFromSting(this.whiteListedAgencies);
        }
        if ((bannedTripMap = this.makeBannedTripMap(this.bannedTrips)) != null) {
            request.bannedTrips = bannedTripMap;
        }
        if (this.transferPenalty != null) {
            request.transferCost = this.transferPenalty;
        }
        if (this.optimize == BicycleOptimizeType.TRANSFERS) {
            this.optimize = BicycleOptimizeType.QUICK;
            request.transferCost += 1800;
        }
        if (this.optimize != null) {
            request.setBicycleOptimizeType(this.optimize);
        }
        if (this.modes != null && !this.modes.qModes.isEmpty()) {
            request.modes = this.modes.getRequestModes();
        }
        if (request.vehicleRental && this.bikeSpeed == null) {
            request.bikeSpeed = 4.3;
        }
        if (this.boardSlack != null) {
            request.boardSlack = this.boardSlack;
        }
        if (this.alightSlack != null) {
            request.alightSlack = this.alightSlack;
        }
        if (this.minTransferTime != null) {
            int alightAndBoardSlack = request.boardSlack + request.alightSlack;
            if (alightAndBoardSlack > this.minTransferTime) {
                throw new IllegalArgumentException("Invalid parameters: 'minTransferTime' must be greater than or equal to board slack plus alight slack");
            }
            request.transferSlack = this.minTransferTime - alightAndBoardSlack;
        }
        if (this.nonpreferredTransferPenalty != null) {
            request.nonpreferredTransferCost = this.nonpreferredTransferPenalty;
        }
        if (this.maxTransfers != null) {
            request.maxTransfers = this.maxTransfers;
        }
        request.useVehicleRentalAvailabilityInformation = request.isTripPlannedForNow();
        if (this.startTransitStopId != null && !this.startTransitStopId.isEmpty()) {
            request.startingTransitStopId = FeedScopedId.parseId(this.startTransitStopId);
        }
        if (this.startTransitTripId != null && !this.startTransitTripId.isEmpty()) {
            request.startingTransitTripId = FeedScopedId.parseId(this.startTransitTripId);
        }
        if (this.ignoreRealtimeUpdates != null) {
            request.ignoreRealtimeUpdates = this.ignoreRealtimeUpdates;
        }
        if (this.disableRemainingWeightHeuristic != null) {
            request.disableRemainingWeightHeuristic = this.disableRemainingWeightHeuristic;
        }
        if (this.disableAlertFiltering != null) {
            request.disableAlertFiltering = this.disableAlertFiltering;
        }
        if (this.geoidElevation != null) {
            request.geoidElevation = this.geoidElevation;
        }
        if (this.pathComparator != null) {
            request.pathComparator = this.pathComparator;
        }
        if (this.debugItineraryFilter != null) {
            request.itineraryFilters.debug = this.debugItineraryFilter;
        }
        if (this.debugRaptorPath != null || this.debugRaptorStops != null) {
            request.raptorDebuging = new DebugRaptor().withStops(this.debugRaptorStops).withPath(this.debugRaptorPath);
        }
        if (this.useVehicleParkingAvailabilityInformation != null) {
            request.useVehicleParkingAvailabilityInformation = this.useVehicleParkingAvailabilityInformation;
        }
        request.locale = ResourceBundleSingleton.INSTANCE.getLocale(this.locale);
        if (OTPFeature.DataOverlay.isOn() && !(queryDataOverlayParameters = DataOverlayParameters.parseQueryParams(queryParameters)).isEmpty()) {
            request.dataOverlay = queryDataOverlayParameters;
        }
        return request;
    }

    public HashMap<FeedScopedId, BannedStopSet> makeBannedTripMap(String banned) {
        String[] tripStrings;
        if (banned == null) {
            return null;
        }
        HashMap<FeedScopedId, BannedStopSet> bannedTripMap = new HashMap<FeedScopedId, BannedStopSet>();
        for (String tripString : tripStrings = banned.split(",")) {
            BannedStopSet bannedStops;
            String[] parts = tripString.split(":");
            if (parts.length < 2) continue;
            String agencyIdString = parts[0];
            String tripIdString = parts[1];
            FeedScopedId tripId = new FeedScopedId(agencyIdString, tripIdString);
            if (parts.length == 2) {
                bannedStops = BannedStopSet.ALL;
            } else {
                bannedStops = new BannedStopSet();
                for (int i = 2; i < parts.length; ++i) {
                    bannedStops.add(Integer.parseInt(parts[i]));
                }
            }
            bannedTripMap.put(tripId, bannedStops);
        }
        return bannedTripMap;
    }
}

