/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.common;

import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.opentripplanner.util.OtpAppException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class OTPExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(OTPExceptionMapper.class);

    public Response toResponse(Exception ex) {
        if (ex instanceof WebApplicationException) {
            String header = "";
            if (ex instanceof BadRequestException) {
                header = "FOUR HUNDRED\n\n";
            } else if (ex instanceof NotFoundException) {
                header = "FOUR ZERO FOUR\n\n";
            }
            return Response.fromResponse((Response)((WebApplicationException)ex).getResponse()).entity((Object)(header + ex.getMessage())).build();
        }
        if (ex instanceof OtpAppException) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("OTP Application error: " + ex.getMessage())).type("text/plain").build();
        }
        LOG.error("Unhandled exception", (Throwable)ex);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(ex.toString() + " " + ex.getMessage())).type("text/plain").build();
    }
}

