/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.common;

import java.util.Locale;
import org.opentripplanner.util.Properties;

public enum Message {
    PLAN_OK(200),
    SYSTEM_ERROR(500),
    GRAPH_UNAVAILABLE(503),
    OUTSIDE_BOUNDS(400),
    PATH_NOT_FOUND(404),
    NO_TRANSIT_TIMES(406),
    REQUEST_TIMEOUT(408),
    BOGUS_PARAMETER(413),
    GEOCODE_FROM_NOT_FOUND(440),
    GEOCODE_TO_NOT_FOUND(450),
    GEOCODE_FROM_TO_NOT_FOUND(460),
    TOO_CLOSE(409),
    LOCATION_NOT_ACCESSIBLE(470),
    UNDERSPECIFIED_TRIANGLE(370),
    TRIANGLE_NOT_AFFINE(371),
    TRIANGLE_OPTIMIZE_TYPE_NOT_SET(372),
    TRIANGLE_VALUES_NOT_SET(373);

    private Properties config = this.getConfig();
    private final int m_id;

    private Message(int id) {
        this.m_id = id;
    }

    public int getId() {
        return this.m_id;
    }

    public Properties getConfig() {
        if (this.config == null) {
            this.config = new Properties(Message.class);
        }
        return this.config;
    }

    public String get(String def, Locale l) {
        try {
            this.getConfig();
            return this.config.get(this.name(), l);
        }
        catch (Exception e) {
            Properties.LOG.warn("No entry in Message.properties file could be found for string " + this.name());
            return def;
        }
    }

    public String get(Locale l) {
        return this.get("", l);
    }

    public String get() {
        return this.get("", Locale.getDefault());
    }
}

