/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.GenericLocation;

public class LocationStringParser {
    private static final String _doublePattern = "-{0,1}\\d+(\\.\\d+){0,1}";
    private static final Pattern _latLonPattern = Pattern.compile("[\\D&&[^-+.]]*(-{0,1}\\d+(\\.\\d+){0,1})(\\s*,\\s*|\\s+)(-{0,1}\\d+(\\.\\d+){0,1})\\D*");

    public static GenericLocation fromOldStyleString(String input) {
        String name = null;
        String place = input;
        if (input.contains("::")) {
            String[] parts = input.split("::", 2);
            name = parts[0];
            place = parts[1];
        }
        return LocationStringParser.getGenericLocation(name, place);
    }

    public static GenericLocation getGenericLocation(String label, String place) {
        if (place == null) {
            return null;
        }
        Double lat = null;
        Double lon = null;
        FeedScopedId placeId = null;
        Matcher matcher = _latLonPattern.matcher(place);
        if (matcher.find()) {
            lat = Double.parseDouble(matcher.group(1));
            lon = Double.parseDouble(matcher.group(4));
        } else if (FeedScopedId.isValidString(place)) {
            placeId = FeedScopedId.parseId(place);
        }
        return new GenericLocation(label, placeId, lat, lon);
    }
}

