/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.awt;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class ShapeStroke
implements Stroke {
    private Shape theShape;
    private float advance;
    private float phase;
    private AffineTransform t = new AffineTransform();
    private static final float FLATNESS = 1.0f;

    public ShapeStroke(Shape shape, float width, float advance, float phase) {
        this.advance = advance;
        this.phase = phase;
        Rectangle2D bounds = shape.getBounds2D();
        double scale = (double)width / bounds.getHeight();
        this.t.setToScale(scale, scale);
        this.t.translate(-bounds.getCenterX(), -bounds.getCenterY());
        this.theShape = this.t.createTransformedShape(shape);
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        GeneralPath result = new GeneralPath();
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] points = new float[6];
        float moveX = 0.0f;
        float moveY = 0.0f;
        float lastX = 0.0f;
        float lastY = 0.0f;
        float thisX = 0.0f;
        float thisY = 0.0f;
        int type = 0;
        float next = this.phase;
        while (!it.isDone()) {
            type = it.currentSegment(points);
            switch (type) {
                case 0: {
                    moveX = lastX = points[0];
                    moveY = lastY = points[1];
                    result.moveTo(moveX, moveY);
                    next = 0.0f;
                    break;
                }
                case 4: {
                    points[0] = moveX;
                    points[1] = moveY;
                }
                case 1: {
                    thisX = points[0];
                    thisY = points[1];
                    float dx = thisX - lastX;
                    float dy = thisY - lastY;
                    float distance = (float)Math.sqrt(dx * dx + dy * dy);
                    if (distance >= next) {
                        float r = 1.0f / distance;
                        float angle = (float)Math.atan2(dy, dx);
                        while (distance >= next) {
                            float x = lastX + next * dx * r;
                            float y = lastY + next * dy * r;
                            this.t.setToTranslation(x, y);
                            this.t.rotate(angle);
                            result.append(this.t.createTransformedShape(this.theShape), false);
                            next += this.advance;
                        }
                    }
                    next -= distance;
                    lastX = thisX;
                    lastY = thisY;
                }
            }
            it.next();
        }
        return result;
    }
}

