/*
 * Decompiled with CFR 0.152.
 */
package org.openshift.jenkins.plugins.openshiftlogin;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.util.SecurityUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.View;
import hudson.scm.SCM;
import hudson.security.AuthorizationStrategy;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import hudson.util.PluginServletFilter;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.openshift.jenkins.plugins.openshiftlogin.AnonymousAuthenticationManager;
import org.openshift.jenkins.plugins.openshiftlogin.BasicAuthenticator;
import org.openshift.jenkins.plugins.openshiftlogin.BearerTokenOAuthSession;
import org.openshift.jenkins.plugins.openshiftlogin.ConfigMapResponse;
import org.openshift.jenkins.plugins.openshiftlogin.CredentialHttpRequestInitializer;
import org.openshift.jenkins.plugins.openshiftlogin.OAuthSession;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftPermissionFilter;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftProviderInfo;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftSubjectAccessReviewRequest;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftSubjectAccessReviewResponse;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftUserDetails;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftUserInfo;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftVersionInfo;
import org.openshift.jenkins.plugins.openshiftlogin.SARRequestHttpContent;

@SuppressFBWarnings
public class OpenShiftOAuth2SecurityRealm
extends SecurityRealm
implements Serializable {
    private static final String EMPTY_STRING = "";
    static final Logger LOGGER = Logger.getLogger(OpenShiftOAuth2SecurityRealm.class.getName());
    private static final String SCOPE_INFO = "user:info";
    private static final String SCOPE_CHECK_ACCESS = "user:check-access";
    static final String DEFAULT_SVC_ACCT_DIR = "/run/secrets/kubernetes.io/serviceaccount";
    static final String DEFAULT_SVR_PREFIX = "https://kubernetes.default:443";
    static final String NAMESPACE = "namespace";
    private static final String TOKEN = "token";
    private static final String CA_CRT = "ca.crt";
    private static final String FINISH_METHOD = "doFinishLogin";
    private static final String START_METHOD = "doCommenceLogin";
    private static final String DISPLAY_NAME = "Login with OpenShift";
    private static final String LOGIN_URL = "securityRealm/commenceLogin";
    private static final String USER_URI = "/apis/user.openshift.io/v1/users/~";
    private static final String SAR_URI = "/apis/authorization.openshift.io/v1/subjectaccessreviews";
    private static final String CONFIG_MAP_URI = "/api/v1/namespaces/%s/configmaps/openshift-jenkins-login-plugin-config";
    private static final String OAUTH_PROVIDER_URI = "/.well-known/oauth-authorization-server";
    private static final String K8S_HOST_ENV_VAR = "KUBERNETES_SERVICE_HOST";
    private static final String K8S_PORT_ENV_VAR = "KUBERNETES_SERVICE_PORT";
    private static final String LOGOUT = "logout";
    static final String LOGGING_OUT = "loggingOut";
    private static final String HTTPS_SCHEME = "https";
    private static final String HTTP_SCHEME = "http";
    private static final String SCHEME_SEPARATOR = "://";
    private static final String PORT_SEPARATOR = ":";
    private static final Locale DEFAULT_LOCALE_PERMISSION = Locale.US;
    public static final String SECURITY_REALM_FINISH_LOGIN = "/securityRealm/finishLogin";
    static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final Object USER_UPDATE_LOCK = new Object();
    private static final ArrayList<String> roles = new ArrayList<String>(Arrays.asList("admin", "edit", "view"));
    private static final String HTTPS_PROXY_USER = "https.proxyUser";
    private static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    String redirectUrl;
    static HttpTransport testTransport;
    private static HttpTransport transport;
    private static HttpTransport jvmDefaultKeystoreTransport;
    private final String serviceAccountDirectory;
    private String defaultedServiceAccountDirectory;
    private final String serviceAccountName;
    private String defaultedServiceAccountName;
    private final String serverPrefix;
    private String defaultedServerPrefix;
    private final String redirectURL;
    private String defaultedRedirectURL;
    private final String clientId;
    private String defaultedClientId;
    private final Secret clientSecret;
    private String defaultedClientSecret;
    private String namespace;
    private OpenShiftProviderInfo provider;
    private OpenShiftPermissionFilter filter;

    @DataBoundConstructor
    public OpenShiftOAuth2SecurityRealm(String serviceAccountDirectory, String serviceAccountName, String serverPrefix, String clientId, String clientSecret, String redirectURL) throws IOException, GeneralSecurityException {
        HttpTransport transport = HTTP_TRANSPORT;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("ctor: incoming args sa dir %s sa name %s svr prefix %s client id %s client secret %s redirectURL %s", serviceAccountDirectory, serviceAccountName, serverPrefix, clientId, clientSecret, redirectURL));
        }
        String fixedServiceAccountDirectory = Util.fixEmpty((String)serviceAccountDirectory);
        this.clientId = Util.fixEmpty((String)clientId);
        this.clientSecret = Util.fixEmpty((String)clientSecret) != null ? Secret.fromString((String)clientSecret) : null;
        this.defaultedServerPrefix = DEFAULT_SVR_PREFIX;
        this.serverPrefix = Util.fixEmpty((String)serverPrefix);
        this.redirectURL = Util.fixEmpty((String)redirectURL);
        this.defaultedServiceAccountDirectory = DEFAULT_SVC_ACCT_DIR;
        this.serviceAccountDirectory = fixedServiceAccountDirectory;
        this.serviceAccountName = Util.fixEmpty((String)serviceAccountName);
        OpenShiftOAuth2SecurityRealm.transport = transport;
        jvmDefaultKeystoreTransport = new NetHttpTransport.Builder().build();
        if (testTransport != null) {
            OpenShiftOAuth2SecurityRealm.transport = testTransport;
        } else {
            this.populateDefaults();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("ctor: derived default client id %s client secret %s sa dir %s transport %s", this.defaultedClientId, this.defaultedClientSecret, this.defaultedServiceAccountDirectory, transport));
        }
    }

    synchronized void createFilter() {
        if (this.filter == null || !this.filter.initCalled) {
            try {
                this.filter = new OpenShiftPermissionFilter();
                PluginServletFilter.addFilter((Filter)this.filter);
            }
            catch (ServletException e) {
                LOGGER.log(Level.SEVERE, "createFilter", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean populateDefaults() throws IOException, GeneralSecurityException {
        boolean withinAPod;
        boolean runningInOpenShiftPodWithRequiredOAuthFeatures;
        block22: {
            this.createFilter();
            runningInOpenShiftPodWithRequiredOAuthFeatures = EnvVars.masterEnvVars.get(K8S_HOST_ENV_VAR) != null && EnvVars.masterEnvVars.get(K8S_PORT_ENV_VAR) != null;
            withinAPod = runningInOpenShiftPodWithRequiredOAuthFeatures || new File(this.getDefaultedServiceAccountDirectory()).exists();
            FileInputStream fis = null;
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(new File(this.getDefaultedServiceAccountDirectory(), NAMESPACE)));
                this.namespace = br.readLine();
                runningInOpenShiftPodWithRequiredOAuthFeatures = runningInOpenShiftPodWithRequiredOAuthFeatures && this.namespace != null && this.namespace.length() > 0;
                br = new BufferedReader(new FileReader(new File(this.getDefaultedServiceAccountDirectory(), TOKEN)));
                this.defaultedClientSecret = br.readLine();
                runningInOpenShiftPodWithRequiredOAuthFeatures = runningInOpenShiftPodWithRequiredOAuthFeatures && this.defaultedClientSecret != null && this.defaultedClientSecret.length() > 0;
                fis = new FileInputStream(new File(this.getDefaultedServiceAccountDirectory(), CA_CRT));
                KeyStore keyStore = SecurityUtils.getDefaultKeyStore();
                try {
                    keyStore.size();
                }
                catch (KeyStoreException e) {
                    keyStore.load(null);
                }
                SecurityUtils.loadKeyStoreFromCertificates((KeyStore)keyStore, (CertificateFactory)SecurityUtils.getX509CertificateFactory(), (InputStream)fis);
                transport = new NetHttpTransport.Builder().trustCertificates(keyStore).build();
            }
            catch (FileNotFoundException e) {
                runningInOpenShiftPodWithRequiredOAuthFeatures = false;
                if (LOGGER.isLoggable(Level.FINE) || withinAPod) {
                    LOGGER.log(Level.FINE, "populatateDefaults", e);
                }
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(this.getDefaultedClientSecret().getPlainText());
            try {
                OpenShiftUserInfo user = this.getOpenShiftUserInfo(credential, transport);
                String[] userNameParts = user.getName().split(PORT_SEPARATOR);
                if (userNameParts != null && userNameParts.length == 4) {
                    this.defaultedServiceAccountName = userNameParts[3];
                }
                runningInOpenShiftPodWithRequiredOAuthFeatures = runningInOpenShiftPodWithRequiredOAuthFeatures && this.defaultedServiceAccountName != null && this.defaultedServiceAccountName.length() > 0;
                this.defaultedClientId = "system:serviceaccount:" + this.namespace + PORT_SEPARATOR + this.getDefaultedServiceAccountName();
                this.provider = this.getOpenShiftOAuthProvider(credential, transport);
                if (withinAPod) {
                    LOGGER.info(String.format("OpenShift OAuth: provider: %s", this.provider));
                }
                if (this.provider != null) {
                    this.defaultedRedirectURL = this.provider.issuer;
                    if (this.useProviderOAuthEndpoint(credential)) {
                        this.transportToUse(credential);
                    }
                } else {
                    runningInOpenShiftPodWithRequiredOAuthFeatures = false;
                }
            }
            catch (Throwable t) {
                runningInOpenShiftPodWithRequiredOAuthFeatures = false;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "populateDefaults", t);
                }
                if (!withinAPod) break block22;
                LOGGER.log(Level.INFO, "populateDefaults", t);
            }
        }
        if (!runningInOpenShiftPodWithRequiredOAuthFeatures) {
            boolean hasRedirectURL;
            boolean hasSAName = this.serviceAccountName != null || this.defaultedServiceAccountName != null;
            boolean hasSecret = this.clientSecret != null || this.defaultedClientSecret != null;
            boolean hasClientID = this.clientId != null || this.defaultedClientId != null;
            boolean hasClientSecret = this.clientSecret != null || this.defaultedClientSecret != null;
            boolean bl = hasRedirectURL = this.redirectURL != null || this.defaultedRedirectURL != null;
            if (this.namespace != null && hasSAName && hasSecret && hasClientID && hasClientSecret && hasRedirectURL) {
                runningInOpenShiftPodWithRequiredOAuthFeatures = true;
            }
        }
        if (withinAPod) {
            String redactedClientSecret = Secret.toString((Secret)this.clientSecret).length() > 6 ? Secret.toString((Secret)this.clientSecret).substring(0, 5) + "......." : "null";
            String redactedDefaultClientSecret = this.defaultedClientSecret != null && this.defaultedClientSecret.length() > 6 ? this.defaultedClientSecret.substring(0, 5) + "......." : "null";
            String msg1 = "OpenShift OAuth running in k8s/openshift: [%s] with namespace [%s] ServiceAccount directory [%s]";
            String msg2 = "     default ServiceAccount directory [%s] , serviceAccountName [%s], ";
            String msg3 = "     clientId: [%s],  default clientID: [%s], clientSecret: [%s], default clientSecret: [%s],";
            String msg4 = "     redirectUrl: [%s], default redirectUrl: [%s], serverPrefix: [%s], defaultedServerPrefix:[%s]";
            LOGGER.info(String.format(msg1, runningInOpenShiftPodWithRequiredOAuthFeatures, this.namespace, this.serviceAccountDirectory));
            LOGGER.info(String.format(msg2, this.defaultedServiceAccountDirectory, this.serviceAccountName));
            LOGGER.info(String.format(msg3, this.defaultedServiceAccountName, this.clientId, this.defaultedClientId, redactedClientSecret, redactedDefaultClientSecret));
            LOGGER.info(String.format(msg4, this.redirectURL, this.defaultedRedirectURL, this.serverPrefix, this.defaultedServerPrefix));
        }
        return runningInOpenShiftPodWithRequiredOAuthFeatures;
    }

    public String getServiceAccountDirectory() {
        return this.serviceAccountDirectory;
    }

    public String getDefaultedServiceAccountDirectory() {
        if (this.getServiceAccountDirectory() == null) {
            return this.defaultedServiceAccountDirectory;
        }
        return this.getServiceAccountDirectory();
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public String getDefaultedServiceAccountName() {
        if (this.getServiceAccountName() == null) {
            return this.defaultedServiceAccountName;
        }
        return this.getServiceAccountName();
    }

    public String getServerPrefix() {
        return this.serverPrefix;
    }

    public String getDefaultedServerPrefix() {
        if (this.getServerPrefix() == null) {
            return this.defaultedServerPrefix;
        }
        return this.getServerPrefix();
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public String getDefaultedRedirectURL() {
        if (this.getRedirectURL() == null) {
            return this.defaultedRedirectURL;
        }
        return this.getRedirectURL();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getDefaultedClientId() {
        if (this.getClientId() == null) {
            return this.defaultedClientId;
        }
        return this.getClientId();
    }

    public Secret getClientSecret() {
        return this.clientSecret;
    }

    public Secret getDefaultedClientSecret() {
        if (this.getClientSecret() == null) {
            return Secret.fromString((String)this.defaultedClientSecret);
        }
        return this.getClientSecret();
    }

    public String getDefaultedNamespace() {
        return this.namespace;
    }

    public String getLoginUrl() {
        return LOGIN_URL;
    }

    private OpenShiftProviderInfo getOpenShiftOAuthProvider(Credential credential, HttpTransport transport) throws IOException {
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)new CredentialHttpRequestInitializer(credential));
        String oauthProviderUrl = this.getDefaultedServerPrefix() + OAUTH_PROVIDER_URI;
        LOGGER.info("Trying to determine OpenShift Provider information from URL: " + oauthProviderUrl);
        GenericUrl url = new GenericUrl(oauthProviderUrl);
        HttpRequest request = requestFactory.buildGetRequest(url);
        OpenShiftProviderInfo info = (OpenShiftProviderInfo)request.execute().parseAs(OpenShiftProviderInfo.class);
        LOGGER.info("OpenShift Provider information parsed as: " + info);
        return info;
    }

    private HttpTransport transportToUse(Credential credential) {
        this.initializeHttpsProxyAuthenticator();
        if (this.provider == null) {
            return transport;
        }
        try {
            HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)new CredentialHttpRequestInitializer(credential));
            GenericUrl url = new GenericUrl(this.provider.token_endpoint);
            HttpRequest request = requestFactory.buildHeadRequest(url);
            request.execute().getStatusCode();
        }
        catch (HttpResponseException hre) {
            if (hre.getStatusCode() == 404) {
                LOGGER.log(Level.INFO, "OpenShift OAuth got an unexpected 404 trying out the issuer's token endpoint", hre);
            }
        }
        catch (SSLHandshakeException ssle) {
            String formattedMessage = "OpenShift OAuth got an SSL error when accessing the issuer's token endpoint when using the SA certificate";
            LOGGER.info(formattedMessage);
            try {
                if (jvmDefaultKeystoreTransport == null) {
                    LOGGER.log(Level.INFO, "jvmDefaultKeystoreTransport was not initialized: Forcing initalization");
                    jvmDefaultKeystoreTransport = new NetHttpTransport.Builder().build();
                }
                HttpRequestFactory requestFactory = jvmDefaultKeystoreTransport.createRequestFactory((HttpRequestInitializer)new CredentialHttpRequestInitializer(credential));
                GenericUrl url = new GenericUrl(this.provider.token_endpoint);
                HttpRequest request = requestFactory.buildHeadRequest(url);
                request.execute().getStatusCode();
                LOGGER.info("OpenShift OAuth was able to complete the SSL handshake when accessing the issuer's token endpoint using the JVMs default keystore");
            }
            catch (HttpResponseException hre) {
                LOGGER.info("OpenShift OAuth was able to complete the SSL handshake when accessing the issuer's token endpoint using the JVMs default keystore");
                return jvmDefaultKeystoreTransport;
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, "OpenShift OAuth provider token endpoint failed unexpectedly using the JVMs default keystore", t);
                return jvmDefaultKeystoreTransport;
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.INFO, "OpenShift OAuth provider token endpoint failed unexpectedly using this pod's SA's certificate", t);
        }
        return transport;
    }

    private void initializeHttpsProxyAuthenticator() {
        String username = System.getProperty(HTTPS_PROXY_USER);
        String password = System.getProperty(HTTPS_PROXY_PASSWORD);
        LOGGER.log(Level.INFO, "Checking if HTTPS proxy initialization is required ... ");
        if (username != null && password != null) {
            LOGGER.log(Level.FINE, "https.proxyUser or https.proxyPassword found in system properties...");
            LOGGER.log(Level.INFO, "Creating basic authenticator for HTTPS proxy auth");
            Authenticator.setDefault(new BasicAuthenticator(username, password));
        }
    }

    private boolean useProviderOAuthEndpoint(Credential credential) {
        if (this.provider == null) {
            LOGGER.log(Level.WARNING, "OpenShift OAuth has not provider defined.");
            return false;
        }
        try {
            LOGGER.info("OpenShift OAuth will query  " + this.defaultedServerPrefix + "/version with credentials " + credential);
            GenericUrl url = new GenericUrl(this.defaultedServerPrefix + "/version");
            HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)new CredentialHttpRequestInitializer(credential));
            HttpRequest request = requestFactory.buildGetRequest(url);
            HttpResponse response = request.execute();
            int rc = response.getStatusCode();
            if (rc != 200) {
                LOGGER.info("OpenShift OAuth the attempt to get the server version request got an unexpected return code: " + rc);
            }
            LOGGER.info("Server succesfully queried to get OpenShift version, now parsing it...");
            OpenShiftVersionInfo version = (OpenShiftVersionInfo)response.parseAs(OpenShiftVersionInfo.class);
            if (version != null) {
                boolean isOpenShift3Cluster = version.isOpenShift3Cluster();
                LOGGER.info("Now checking if we are on an OpenShift3 cluster and the answer is:  " + isOpenShift3Cluster);
                return version.isOpenShift4Cluster();
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.INFO, "Failed to get version attempt failed", t);
        }
        LOGGER.info("Determining OpenShift version failed...falling back into OpenShift3 behaviour");
        return false;
    }

    private OpenShiftUserInfo getOpenShiftUserInfo(Credential credential, HttpTransport transport) throws IOException {
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)new CredentialHttpRequestInitializer(credential));
        GenericUrl url = new GenericUrl(this.getDefaultedServerPrefix() + USER_URI);
        HttpRequest request = requestFactory.buildGetRequest(url);
        OpenShiftUserInfo info = (OpenShiftUserInfo)((Object)request.execute().parseAs(OpenShiftUserInfo.class));
        return info;
    }

    private String buildSARJson(String namespace, String verb) throws IOException {
        OpenShiftSubjectAccessReviewRequest request = new OpenShiftSubjectAccessReviewRequest();
        request.namespace = namespace;
        request.verb = verb;
        String json = CredentialHttpRequestInitializer.JSON_FACTORY.toString((Object)request);
        return json;
    }

    private HttpRequest buildPostSARRequest(HttpRequestFactory requestFactory, GenericUrl url, String json) throws IOException {
        SARRequestHttpContent contentAdmin = new SARRequestHttpContent(json);
        return requestFactory.buildPostRequest(url, (HttpContent)contentAdmin);
    }

    private ArrayList<String> postSAR(Credential credential, HttpTransport transport) throws IOException {
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)new CredentialHttpRequestInitializer(credential));
        GenericUrl url = new GenericUrl(this.getDefaultedServerPrefix() + SAR_URI);
        ArrayList<String> allowedRoles = new ArrayList<String>();
        for (String verb : roles) {
            OpenShiftSubjectAccessReviewResponse review;
            HttpRequest request;
            String json = this.buildSARJson(this.namespace, verb);
            if (json == null) {
                LOGGER.info("DBG json null ... namespace " + this.namespace + " verb " + verb);
            }
            if ((request = this.buildPostSARRequest(requestFactory, url, json)) == null) {
                LOGGER.info("DBG request null");
            }
            if ((review = (OpenShiftSubjectAccessReviewResponse)request.execute().parseAs(OpenShiftSubjectAccessReviewResponse.class)) == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("postSAR: response for verb %s hydrated into obj: namespace %s allowed %s reason %s", verb, review.namespace, Boolean.toString(review.allowed), review.reason));
            }
            if (!review.allowed || allowedRoles.contains(verb)) continue;
            allowedRoles.add(verb);
        }
        return allowedRoles;
    }

    private Map<String, List<Permission>> getRoleToPermissionMap(HttpTransport transport) {
        HashMap<String, List<Permission>> rolesToPermissionsMap = new HashMap<String, List<Permission>>();
        ArrayList<Permission> viewPerms = new ArrayList<Permission>(Arrays.asList(Hudson.READ, Item.READ, Item.DISCOVER, CredentialsProvider.VIEW));
        rolesToPermissionsMap.put("view", viewPerms);
        ArrayList<Permission> editPerms = new ArrayList<Permission>(viewPerms);
        editPerms.addAll(new ArrayList<Permission>(Arrays.asList(Item.BUILD, Item.CONFIGURE, Item.CREATE, Item.DELETE, Item.CANCEL, Item.WORKSPACE, SCM.TAG, Jenkins.RUN_SCRIPTS)));
        rolesToPermissionsMap.put("edit", editPerms);
        ArrayList<Permission> adminPerms = new ArrayList<Permission>(editPerms);
        adminPerms.addAll(new ArrayList<Permission>(Arrays.asList(Computer.CONFIGURE, Computer.DELETE, Hudson.ADMINISTER, Hudson.READ, Run.DELETE, Run.UPDATE, View.CONFIGURE, View.CREATE, View.DELETE, CredentialsProvider.CREATE, CredentialsProvider.UPDATE, CredentialsProvider.DELETE, CredentialsProvider.MANAGE_DOMAINS)));
        rolesToPermissionsMap.put("admin", adminPerms);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(this.getDefaultedClientSecret().getPlainText());
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)new CredentialHttpRequestInitializer(credential));
        GenericUrl url = new GenericUrl(this.getDefaultedServerPrefix() + String.format(CONFIG_MAP_URI, this.namespace));
        HttpRequest request = null;
        ConfigMapResponse response = null;
        String prefix = "OpenShift Jenkins Login Plugin";
        try {
            request = requestFactory.buildGetRequest(url);
            response = (ConfigMapResponse)request.execute().parseAs(ConfigMapResponse.class);
        }
        catch (IOException e) {
            LOGGER.info(prefix + " could not find the openshift-jenkins-login-plugin-config config map in namespace " + this.namespace + " so the default permission mapping will be used");
            LOGGER.log(Level.FINE, "getRoleToPermissionMap", e);
            return rolesToPermissionsMap;
        }
        if (response == null || response.data == null || response.data.size() == 0) {
            LOGGER.info(prefix + " did not see the openshift-jenkins-login-plugin-config config map in namespace " + this.namespace + " so the default permission mapping will be used");
            return rolesToPermissionsMap;
        }
        rolesToPermissionsMap.clear();
        List permissionsInSystem = Permission.getAll();
        for (Map.Entry<String, String> entry : response.data.entrySet()) {
            String permissionAsString = entry.getKey();
            String[] parsedPermission = permissionAsString.trim().split("-");
            if (parsedPermission == null || parsedPermission.length != 2) {
                LOGGER.info(prefix + " ignore permission string " + permissionAsString + " since if is not of the form <permGroupId>-<permId>");
                continue;
            }
            Permission permission = null;
            for (Permission systemPermission : permissionsInSystem) {
                String systemPermissionString = systemPermission.group.title.toString(DEFAULT_LOCALE_PERMISSION).trim();
                String permissionGroupId = parsedPermission[0].trim();
                String permissionName = systemPermission.name.trim();
                String permissionId = parsedPermission[1].trim();
                LOGGER.fine("Permission in system (forced in en_US locale)" + systemPermissionString + ", Permission Group ID" + permissionGroupId);
                LOGGER.fine("Permission Name " + permissionName + ", Permission ID " + permissionId);
                if (!systemPermissionString.equalsIgnoreCase(permissionGroupId) || !permissionName.equalsIgnoreCase(permissionId)) continue;
                permission = systemPermission;
                LOGGER.info(prefix + " matching configured permission " + permissionAsString + " to Jenkins permission " + permission);
                break;
            }
            if (permission == null) {
                LOGGER.warning(prefix + " could not find permission " + permissionAsString + " in Jenkins list of all available permissions");
                continue;
            }
            String rolesList = entry.getValue();
            if (rolesList == null) {
                LOGGER.warning("No roles specified for permission " + permissionAsString + " in login plugin config map");
                continue;
            }
            String[] permissionRoles = rolesList.split(",");
            if (permissionRoles == null || permissionRoles.length == 0) {
                LOGGER.warning("No roles specified for permission " + permissionAsString + " in login plugin config map: " + rolesList);
            }
            for (String role : permissionRoles) {
                ArrayList<Permission> permissions = (ArrayList<Permission>)rolesToPermissionsMap.get(role);
                if (permissions == null) {
                    permissions = new ArrayList<Permission>();
                    rolesToPermissionsMap.put(role, permissions);
                }
                if (permissions.contains(permission)) continue;
                LOGGER.info(prefix + " adding permission " + permissionAsString + " for role " + role);
                permissions.add(permission);
            }
        }
        roles.clear();
        for (String key : rolesToPermissionsMap.keySet()) {
            if (roles.contains(key)) continue;
            roles.add(key);
        }
        LOGGER.info(prefix + " using role list " + roles);
        return rolesToPermissionsMap;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents((AuthenticationManager)new AnonymousAuthenticationManager());
    }

    protected OAuthSession newOAuthSession(String from, String redirectOnFinish) throws MalformedURLException {
        HttpTransport transportForThisRequest = transport;
        GenericUrl tsu = new GenericUrl(this.getDefaultedServerPrefix() + "/oauth/token");
        String asu = this.getDefaultedRedirectURL() + "/oauth/authorize";
        String accessToken = this.getDefaultedClientSecret().getPlainText();
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        if (this.useProviderOAuthEndpoint(credential)) {
            LOGGER.info("OpenShift OAuth using OAuth Provider specified endpoints for this login flow");
            tsu = new GenericUrl(this.provider.token_endpoint);
            asu = this.provider.authorization_endpoint;
            transportForThisRequest = this.transportToUse(credential);
        } else {
            LOGGER.warning("OpenShift OAuth will use the OpenShift Jenkins Login Plugin default for the OAuth endpoints");
        }
        GenericUrl tokenServerURL = tsu;
        String authorizationServerURL = asu;
        String defaultedClientId = this.getDefaultedClientId();
        ClientParametersAuthentication clientAuthentication = new ClientParametersAuthentication(defaultedClientId, accessToken);
        List<String> scopes = Arrays.asList(SCOPE_INFO, SCOPE_CHECK_ACCESS);
        Credential.AccessMethod queryParameters = BearerToken.queryParameterAccessMethod();
        LOGGER.info(String.format("Performing OpenShift AuthorizationCodeFlow using: tokenServerURL=[%s]", tokenServerURL.toString()));
        LOGGER.info(String.format("AuthorizationCodeFlow using : queryParameters=[%s], transport=[%s], ", queryParameters, transportForThisRequest));
        LOGGER.info(String.format("AuthorizationCodeFlow using : clientAuthentication=[%s], clientId=[%s], ", clientAuthentication, defaultedClientId));
        LOGGER.info(String.format("AuthorizationCodeFlow using : authorizationServerURL=[%s], ", authorizationServerURL));
        AuthorizationCodeFlow flow = new AuthorizationCodeFlow.Builder(queryParameters, transportForThisRequest, CredentialHttpRequestInitializer.JSON_FACTORY, tokenServerURL, (HttpExecuteInterceptor)clientAuthentication, defaultedClientId, authorizationServerURL).setScopes(scopes).build();
        OpenShiftOAuth2SecurityRealm secRealm = this;
        String url = this.buildOAuthRedirectUrl(redirectOnFinish);
        BearerTokenOAuthSession bearerTokenOAuthSession = new BearerTokenOAuthSession(flow, from, url, redirectOnFinish, url, flow, secRealm);
        LOGGER.info(String.format("The created BearerTokenOAuthSession  is  [%s]", bearerTokenOAuthSession.toString()));
        return bearerTokenOAuthSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsernamePasswordAuthenticationToken updateAuthorizationStrategy(Credential credential) throws IOException, GeneralSecurityException {
        this.populateDefaults();
        OpenShiftUserInfo info = this.getOpenShiftUserInfo(credential, transport);
        Map<String, List<Permission>> cfgedRolePermMap = this.getRoleToPermissionMap(transport);
        ArrayList<String> allowedRoles = this.postSAR(credential, transport);
        GrantedAuthority[] authorities = new GrantedAuthority[]{SecurityRealm.AUTHENTICATED_AUTHORITY};
        String suffix = null;
        for (String role : allowedRoles) {
            if (suffix == null) {
                suffix = "-" + role;
                continue;
            }
            suffix = suffix + "-" + role;
        }
        UsernamePasswordAuthenticationToken token = null;
        if (suffix != null) {
            String matrixKey = info.getName() + suffix;
            token = new UsernamePasswordAuthenticationToken((Object)matrixKey, (Object)EMPTY_STRING, authorities);
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
            User u = User.get((String)token.getName());
            info.updateProfile(u);
            u.setFullName(info.getName());
            u.save();
            SecurityListener.fireAuthenticated((UserDetails)new OpenShiftUserDetails(token.getName(), authorities));
            Object object = USER_UPDATE_LOCK;
            synchronized (object) {
                GlobalMatrixAuthorizationStrategy existingAuthMgr = (GlobalMatrixAuthorizationStrategy)Jenkins.getInstance().getAuthorizationStrategy();
                Set usersGroups = existingAuthMgr.getGroups();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("updateAuthorizationStrategy: got users %s where this user is %s", usersGroups.toString(), info.getName()));
                }
                if (usersGroups.contains(matrixKey)) {
                    LOGGER.info(String.format("OpenShift OAuth: user %s, stored in the matrix as %s, based on OpenShift roles %s already exists in Jenkins", info.getName(), matrixKey, allowedRoles));
                } else {
                    ArrayList permissionGroups = new ArrayList(PermissionGroup.getAll());
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("updateAuthorizationStrategy: permissions %s", ((Object)permissionGroups).toString()));
                    }
                    Object newAuthMgr = null;
                    newAuthMgr = existingAuthMgr instanceof ProjectMatrixAuthorizationStrategy ? new ProjectMatrixAuthorizationStrategy() : new GlobalMatrixAuthorizationStrategy();
                    if (newAuthMgr != null) {
                        for (String userGroup : usersGroups) {
                            for (PermissionGroup pg : permissionGroups) {
                                for (Permission p : pg.getPermissions()) {
                                    if (!existingAuthMgr.hasPermission(userGroup, p)) continue;
                                    newAuthMgr.add(p, userGroup);
                                }
                            }
                        }
                        LOGGER.info(String.format("OpenShift OAuth: adding permissions for user %s, stored in the matrix as %s, based on OpenShift roles %s", info.getName(), matrixKey, allowedRoles));
                        for (String role : allowedRoles) {
                            List<Permission> perms = cfgedRolePermMap.get(role);
                            for (Permission perm : perms) {
                                newAuthMgr.add(perm, matrixKey);
                            }
                        }
                        Jenkins.getInstance().setAuthorizationStrategy((AuthorizationStrategy)newAuthMgr);
                        try {
                            Jenkins.getInstance().save();
                        }
                        catch (Throwable t) {
                            LOGGER.log(Level.INFO, "updateAuthorizationStrategy", t);
                        }
                    }
                }
            }
        }
        return token;
    }

    public org.kohsuke.stapler.HttpResponse doCommenceLogin(@QueryParameter String from, @Header(value="Referer") String referer) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.entering(OpenShiftOAuth2SecurityRealm.class.getName(), START_METHOD, new Object[]{from, referer});
        }
        try {
            this.populateDefaults();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        URL fromURL = null;
        URL refererURL = null;
        try {
            fromURL = new URL(from);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            refererURL = new URL(referer);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String redirectOnFinish = fromURL != null ? from : (refererURL != null ? referer : Jenkins.getInstance().getRootUrl());
        return this.newOAuthSession(from, redirectOnFinish).doCommenceLogin();
    }

    public String buildOAuthRedirectUrl(String redirect) throws MalformedURLException {
        if (this.redirectUrl != null) {
            return this.redirectUrl;
        }
        URL url = null;
        url = new URL(redirect);
        String protocol = url.getProtocol();
        if (url != null && (protocol.equalsIgnoreCase(HTTP_SCHEME) || protocol.equalsIgnoreCase(HTTPS_SCHEME))) {
            StaplerRequest req = Stapler.getCurrentRequest();
            String contextPath = req != null ? req.getContextPath().trim() : EMPTY_STRING;
            String prefix = StringUtils.isNotBlank((String)contextPath.trim()) ? contextPath : EMPTY_STRING;
            int defaultPort = url.getDefaultPort();
            int port = url.getPort();
            String redirectPort = port > 0 && port != defaultPort ? PORT_SEPARATOR + port : EMPTY_STRING;
            StringBuilder sb = new StringBuilder(protocol).append(SCHEME_SEPARATOR).append(url.getHost());
            sb.append(redirectPort).append(prefix).append(SECURITY_REALM_FINISH_LOGIN);
            return sb.toString();
        }
        throw new MalformedURLException("redirect url " + redirect + " insufficient");
    }

    public org.kohsuke.stapler.HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            if (request != null) {
                LOGGER.entering(OpenShiftOAuth2SecurityRealm.class.getName(), FINISH_METHOD, new Object[]{request.getQueryString(), request.getRequestURL()});
            } else {
                LOGGER.entering(OpenShiftOAuth2SecurityRealm.class.getName(), FINISH_METHOD);
            }
        }
        if (OAuthSession.getCurrent() != null) {
            return OAuthSession.getCurrent().doFinishLogin(request);
        }
        return new HttpRedirect(Jenkins.getInstance().getRootUrl());
    }

    protected String getPostLogOutUrl(StaplerRequest req, Authentication auth) {
        if (req.getRequestURL().toString().contains(LOGOUT)) {
            req.getSession().setAttribute(LOGGING_OUT, (Object)LOGGING_OUT);
        }
        return req.getRequestURL().toString().replace(LOGOUT, EMPTY_STRING);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return OpenShiftOAuth2SecurityRealm.DISPLAY_NAME;
        }

        private FormValidation paramsWithPodDefaults(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.warning((String)"Unless you specify a value here, the assumption will be that Jenkins is running inside an OpenShift pod, where the value is available.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckServiceAccountDirectory(@QueryParameter String value) throws IOException, ServletException {
            return this.paramsWithPodDefaults(value);
        }

        public FormValidation doCheckClientId(@QueryParameter String value) throws IOException, ServletException {
            return this.paramsWithPodDefaults(value);
        }

        public FormValidation doCheckClientSecret(@QueryParameter String value) throws IOException, ServletException {
            return this.paramsWithPodDefaults(value);
        }

        public FormValidation doCheckServerPrefix(@QueryParameter String value) throws IOException, ServletException {
            return this.paramsWithPodDefaults(value);
        }

        public FormValidation doCheckRedirectURL(@QueryParameter String value) throws IOException, ServletException {
            return this.paramsWithPodDefaults(value);
        }

        public FormValidation doCheckServiceAccountName(@QueryParameter String value) throws IOException, ServletException {
            return this.paramsWithPodDefaults(value);
        }
    }
}

