/*
 * Decompiled with CFR 0.152.
 */
package org.openshift.jenkins.plugins.openshiftlogin;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.listeners.ItemListener;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftOAuth2SecurityRealm;

@Extension
public class OpenShiftItemListener
extends ItemListener {
    static final Logger LOGGER = Logger.getLogger(OpenShiftItemListener.class.getName());
    private static final String OPENSHIFT_ENABLE_OAUTH = "OPENSHIFT_ENABLE_OAUTH";

    public void onLoaded() {
        Jenkins jenkins = Jenkins.getInstance();
        String enabled = (String)EnvVars.masterEnvVars.get(OPENSHIFT_ENABLE_OAUTH);
        LOGGER.info("OpenShift OAuth: enable oauth set to " + enabled);
        if (jenkins != null && enabled != null && !enabled.equalsIgnoreCase("false")) {
            SecurityRealm priorSecurityRealm = jenkins.getSecurityRealm();
            LOGGER.info("OpenShift OAuth: configured security realm on startup: " + priorSecurityRealm);
            if (!(priorSecurityRealm instanceof OpenShiftOAuth2SecurityRealm)) {
                try {
                    boolean inOpenShiftPod;
                    OpenShiftOAuth2SecurityRealm osrealm;
                    block8: {
                        osrealm = new OpenShiftOAuth2SecurityRealm(null, null, null, null, null, null);
                        inOpenShiftPod = false;
                        try {
                            inOpenShiftPod = osrealm.populateDefaults();
                        }
                        catch (Throwable t) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block8;
                            LOGGER.log(Level.FINE, "OpenShiftItemListener", t);
                        }
                    }
                    LOGGER.info("OpenShift OAuth: running in OpenShift pod with required OAuth features: " + inOpenShiftPod);
                    if (inOpenShiftPod) {
                        jenkins.setSecurityRealm((SecurityRealm)osrealm);
                        LOGGER.info("OpenShift OAuth: Jenkins security realm set to OpenShift OAuth");
                    }
                }
                catch (IOException iOException) {
                }
                catch (GeneralSecurityException generalSecurityException) {
                    // empty catch block
                }
            }
        }
    }
}

