/*
 * Decompiled with CFR 0.152.
 */
package org.openshift.jenkins.plugins.openshiftlogin;

import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class OpenShiftHttpRedirectWithPrompt
extends RuntimeException
implements HttpResponse {
    private final int statusCode;
    private final String url;
    public static HttpRedirect DOT = new HttpRedirect(".");
    public static HttpResponse CONTEXT_ROOT = OpenShiftHttpRedirectWithPrompt.fromContextPath("");

    public OpenShiftHttpRedirectWithPrompt(@Nonnull String url) {
        this(302, url);
    }

    public OpenShiftHttpRedirectWithPrompt(int statusCode, @Nonnull String url) {
        this.statusCode = statusCode;
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
    }

    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        PrintWriter w = rsp.getWriter();
        if (w != null) {
            rsp.setContentType("text/html");
            w.println("<!DOCTYPE html>");
            w.println("<html>");
            w.println("<body onload=\"myFunction()\">");
            w.println("<p id=\"demo\"></p>");
            w.println("<script>");
            w.println("function myFunction() {");
            w.println("var x;");
            w.println("if (confirm(\"Press OK to log into Jenkins via OpenShift. Press Cancel to abort login.\") == true) {");
            w.println("x = \"Redirecting to the OpenShift OAuth server ...\";");
            w.println("window.location.href = \"" + this.url + "\"");
            w.println("} else {");
            w.println("x = \"You aborted logging into Jenkins via OpenShift OAuth.\";");
            w.println("}");
            w.println("document.getElementById(\"demo\").innerHTML = x;");
            w.println("}");
            w.println("</script>");
            w.println("</body>");
            w.println("</html>");
            w.flush();
        } else {
            rsp.sendRedirect(this.statusCode, this.url);
        }
    }

    public static HttpResponse fromContextPath(String relative) {
        return HttpResponses.redirectViaContextPath((String)relative);
    }
}

