/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.spi.resources.sharing;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.security.spi.resources.sharing.Recipient;

public class Recipients
implements ToXContentFragment,
NamedWriteable {
    private final Map<Recipient, Set<String>> recipients;

    public Recipients(Map<Recipient, Set<String>> recipients) {
        this.recipients = recipients;
    }

    public Recipients(StreamInput in) throws IOException {
        this.recipients = in.readMap(key -> (Recipient)key.readEnum(Recipient.class), input -> input.readSet(StreamInput::readString));
    }

    public Map<Recipient, Set<String>> getRecipients() {
        return this.recipients;
    }

    public void share(Recipients target) {
        Map<Recipient, Set<String>> targetRecipients = target.getRecipients();
        for (Recipient recipientType : targetRecipients.keySet()) {
            this.recipients.computeIfAbsent(recipientType, k -> new HashSet()).addAll(targetRecipients.getOrDefault((Object)recipientType, Collections.emptySet()));
        }
    }

    public void revoke(Recipients target) {
        Map<Recipient, Set<String>> targetRecipients = target.getRecipients();
        for (Recipient recipientType : targetRecipients.keySet()) {
            this.recipients.computeIfPresent(recipientType, (k, s) -> {
                s.removeAll(targetRecipients.getOrDefault((Object)recipientType, Collections.emptySet()));
                return s;
            });
        }
    }

    public boolean isPublic() {
        return this.recipients.values().stream().anyMatch(recipients -> recipients.contains("*"));
    }

    public boolean isSharedWithAny(Recipient recipientType, Set<String> targets) {
        return !Collections.disjoint(this.recipients.getOrDefault((Object)recipientType, Collections.emptySet()), targets);
    }

    public Set<String> getRecipientsByType(Recipient recipientType) {
        return this.recipients.get((Object)recipientType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<Recipient, Set<String>> entry : this.recipients.entrySet()) {
            builder.array(entry.getKey().getName(), entry.getValue().toArray());
        }
        return builder.endObject();
    }

    public static Recipients fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        HashMap<Recipient, Set<String>> recipients = new HashMap<Recipient, Set<String>>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String fieldName = parser.currentName();
            Recipient recipient = Recipient.valueOf(fieldName.toUpperCase(Locale.ROOT));
            parser.nextToken();
            HashSet<String> values = new HashSet<String>();
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                values.add(parser.text());
            }
            recipients.put(recipient, values);
        }
        return new Recipients(recipients);
    }

    public String toString() {
        return this.recipients.toString();
    }

    public String getWriteableName() {
        return "access_level_recipients";
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.recipients, StreamOutput::writeEnum, (streamOutput, strings) -> streamOutput.writeCollection((Collection)strings, StreamOutput::writeString));
    }
}

