/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.xcontent;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensearch.core.xcontent.AbstractXContentParser;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;

public class MapXContentParser
extends AbstractXContentParser {
    private MediaType xContentType;
    private TokenIterator iterator;
    private boolean closed;

    public MapXContentParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, Map<String, Object> map, MediaType xContentType) {
        super(xContentRegistry, deprecationHandler);
        this.xContentType = xContentType;
        this.iterator = new MapIterator(null, null, map);
    }

    @Override
    protected boolean doBooleanValue() throws IOException {
        if (this.iterator != null && this.iterator.currentValue() instanceof Boolean) {
            return (Boolean)this.iterator.currentValue();
        }
        throw new IllegalStateException("Cannot get boolean value for the current token " + this.currentToken());
    }

    @Override
    protected short doShortValue() throws IOException {
        return this.numberValue().shortValue();
    }

    @Override
    protected int doIntValue() throws IOException {
        return this.numberValue().intValue();
    }

    @Override
    protected long doLongValue() throws IOException {
        return this.numberValue().longValue();
    }

    @Override
    protected float doFloatValue() throws IOException {
        return this.numberValue().floatValue();
    }

    @Override
    protected double doDoubleValue() throws IOException {
        return this.numberValue().doubleValue();
    }

    @Override
    public MediaType contentType() {
        return this.xContentType;
    }

    @Override
    public XContentParser.Token nextToken() throws IOException {
        if (this.iterator == null) {
            return null;
        }
        this.iterator = this.iterator.next();
        return this.currentToken();
    }

    @Override
    public void skipChildren() throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY) {
            this.iterator = this.iterator.skipChildren();
        }
    }

    @Override
    public XContentParser.Token currentToken() {
        if (this.iterator == null) {
            return null;
        }
        return this.iterator.currentToken();
    }

    @Override
    public String currentName() throws IOException {
        if (this.iterator == null) {
            return null;
        }
        return this.iterator.currentName();
    }

    @Override
    public String text() throws IOException {
        if (this.iterator != null) {
            if (this.currentToken() == XContentParser.Token.VALUE_STRING || this.currentToken() == XContentParser.Token.VALUE_NUMBER || this.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                return this.iterator.currentValue().toString();
            }
            if (this.currentToken() == XContentParser.Token.FIELD_NAME) {
                return this.iterator.currentName();
            }
            return null;
        }
        throw new IllegalStateException("Cannot get text for the current token " + this.currentToken());
    }

    @Override
    public CharBuffer charBuffer() throws IOException {
        throw new UnsupportedOperationException("use text() instead");
    }

    @Override
    public Object objectText() throws IOException {
        throw new UnsupportedOperationException("use text() instead");
    }

    @Override
    public Object objectBytes() throws IOException {
        throw new UnsupportedOperationException("use text() instead");
    }

    @Override
    public boolean hasTextCharacters() {
        throw new UnsupportedOperationException("use text() instead");
    }

    @Override
    public char[] textCharacters() throws IOException {
        throw new UnsupportedOperationException("use text() instead");
    }

    @Override
    public int textLength() throws IOException {
        throw new UnsupportedOperationException("use text() instead");
    }

    @Override
    public int textOffset() throws IOException {
        throw new UnsupportedOperationException("use text() instead");
    }

    @Override
    public Number numberValue() throws IOException {
        if (this.iterator != null && this.currentToken() == XContentParser.Token.VALUE_NUMBER) {
            return (Number)this.iterator.currentValue();
        }
        throw new IllegalStateException("Cannot get numeric value for the current token " + this.currentToken());
    }

    @Override
    public XContentParser.NumberType numberType() throws IOException {
        Number number = this.numberValue();
        if (number instanceof Integer) {
            return XContentParser.NumberType.INT;
        }
        if (number instanceof BigInteger) {
            return XContentParser.NumberType.BIG_INTEGER;
        }
        if (number instanceof Long) {
            return XContentParser.NumberType.LONG;
        }
        if (number instanceof Float) {
            return XContentParser.NumberType.FLOAT;
        }
        if (number instanceof Double) {
            return XContentParser.NumberType.DOUBLE;
        }
        if (number instanceof BigDecimal) {
            return XContentParser.NumberType.BIG_DECIMAL;
        }
        throw new IllegalStateException("No matching token for number_type [" + number.getClass() + "]");
    }

    @Override
    public byte[] binaryValue() throws IOException {
        if (this.iterator != null && this.iterator.currentValue() instanceof byte[]) {
            return (byte[])this.iterator.currentValue();
        }
        throw new IllegalStateException("Cannot get binary value for the current token " + this.currentToken());
    }

    @Override
    public XContentLocation getTokenLocation() {
        return new XContentLocation(0, 0);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    private static class MapIterator
    extends TokenIterator {
        private final Iterator<Map.Entry<String, Object>> iterator;
        private Map.Entry<String, Object> entry;

        MapIterator(TokenIterator parent, String name, Map<String, Object> map) {
            super(parent, name);
            this.iterator = map.entrySet().iterator();
        }

        @Override
        public TokenIterator next() {
            switch (this.state) {
                case BEFORE: {
                    this.state = State.NAME;
                    this.currentToken = XContentParser.Token.START_OBJECT;
                    return this;
                }
                case NAME: {
                    if (this.iterator.hasNext()) {
                        this.state = State.VALUE;
                        this.entry = this.iterator.next();
                        this.currentToken = XContentParser.Token.FIELD_NAME;
                        return this;
                    }
                    this.state = State.AFTER;
                    this.entry = null;
                    this.currentToken = XContentParser.Token.END_OBJECT;
                    return this;
                }
                case VALUE: {
                    this.state = State.NAME;
                    return this.processValue(this.entry.getValue());
                }
                case AFTER: {
                    this.currentToken = null;
                    if (this.parent == null) {
                        return null;
                    }
                    return this.parent.next();
                }
            }
            throw new IllegalArgumentException("Unknown state " + this.state);
        }

        @Override
        public TokenIterator skipChildren() {
            this.state = State.AFTER;
            this.entry = null;
            this.currentToken = XContentParser.Token.END_OBJECT;
            return this;
        }

        @Override
        public Object currentValue() {
            if (this.entry == null) {
                throw new IllegalStateException("Cannot get value for non-value token " + this.currentToken);
            }
            return this.entry.getValue();
        }

        @Override
        public String currentName() {
            if (this.entry == null) {
                return this.name;
            }
            return this.entry.getKey();
        }

        @Override
        public String childName() {
            return this.currentName();
        }
    }

    private static abstract class TokenIterator {
        protected final TokenIterator parent;
        protected final String name;
        protected XContentParser.Token currentToken;
        protected State state = State.BEFORE;

        TokenIterator(TokenIterator parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public abstract TokenIterator next();

        public abstract TokenIterator skipChildren();

        public XContentParser.Token currentToken() {
            return this.currentToken;
        }

        public abstract Object currentValue();

        public abstract String currentName();

        public abstract String childName();

        TokenIterator processValue(Object value) {
            if (value instanceof Map) {
                return new MapIterator(this, this.childName(), (Map)value).next();
            }
            if (value instanceof List) {
                return new ArrayIterator(this, this.childName(), (List)value).next();
            }
            if (value instanceof Number) {
                this.currentToken = XContentParser.Token.VALUE_NUMBER;
            } else if (value instanceof String) {
                this.currentToken = XContentParser.Token.VALUE_STRING;
            } else if (value instanceof Boolean) {
                this.currentToken = XContentParser.Token.VALUE_BOOLEAN;
            } else if (value instanceof byte[]) {
                this.currentToken = XContentParser.Token.VALUE_EMBEDDED_OBJECT;
            } else if (value == null) {
                this.currentToken = XContentParser.Token.VALUE_NULL;
            }
            return this;
        }
    }

    private static class ArrayIterator
    extends TokenIterator {
        private final Iterator<Object> iterator;
        private Object value;

        private ArrayIterator(TokenIterator parent, String name, List<Object> list) {
            super(parent, name);
            this.iterator = list.iterator();
        }

        @Override
        public TokenIterator next() {
            switch (this.state) {
                case BEFORE: {
                    this.state = State.VALUE;
                    this.currentToken = XContentParser.Token.START_ARRAY;
                    return this;
                }
                case VALUE: {
                    if (this.iterator.hasNext()) {
                        this.value = this.iterator.next();
                        return this.processValue(this.value);
                    }
                    this.state = State.AFTER;
                    this.value = null;
                    this.currentToken = XContentParser.Token.END_ARRAY;
                    return this;
                }
                case AFTER: {
                    this.currentToken = null;
                    if (this.parent == null) {
                        return null;
                    }
                    return this.parent.next();
                }
            }
            throw new IllegalArgumentException("Unknown state " + this.state);
        }

        @Override
        public TokenIterator skipChildren() {
            this.state = State.AFTER;
            this.value = null;
            this.currentToken = XContentParser.Token.END_ARRAY;
            return this;
        }

        @Override
        public Object currentValue() {
            return this.value;
        }

        @Override
        public String currentName() {
            if (this.parent == null || this.currentToken != XContentParser.Token.START_ARRAY && this.currentToken != XContentParser.Token.END_ARRAY) {
                return null;
            }
            return this.name;
        }

        @Override
        public String childName() {
            return null;
        }
    }

    private static enum State {
        BEFORE,
        NAME,
        VALUE,
        AFTER;

    }
}

