/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.opensearch.Build;
import org.opensearch.LegacyESVersion;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class Version
implements Comparable<Version>,
ToXContentFragment {
    public static final int V_EMPTY_ID = 0;
    public static final Version V_EMPTY = new Version(0, org.apache.lucene.util.Version.LATEST);
    public static final Version V_1_0_0 = new Version(1000099, org.apache.lucene.util.Version.LUCENE_8_8_2);
    public static final Version V_1_1_0 = new Version(1010099, org.apache.lucene.util.Version.LUCENE_8_9_0);
    public static final Version V_1_2_0 = new Version(1020099, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_2_1 = new Version(1020199, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_2_2 = new Version(1020299, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_2_3 = new Version(1020399, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_2_4 = new Version(1020499, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_2_5 = new Version(1020599, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_0 = new Version(1030099, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_1 = new Version(1030199, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_2 = new Version(1030299, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_3 = new Version(1030399, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_4 = new Version(1030499, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_5 = new Version(1030599, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_6 = new Version(1030699, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_7 = new Version(1030799, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_8 = new Version(1030899, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_9 = new Version(1030999, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_10 = new Version(1031099, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_11 = new Version(1031199, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_12 = new Version(1031299, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_13 = new Version(1031399, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_14 = new Version(1031499, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_1_3_15 = new Version(1031599, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_2_0_0 = new Version(2000099, org.apache.lucene.util.Version.LUCENE_9_1_0);
    public static final Version V_2_0_1 = new Version(2000199, org.apache.lucene.util.Version.LUCENE_9_1_0);
    public static final Version V_2_0_2 = new Version(2000299, org.apache.lucene.util.Version.LUCENE_9_1_0);
    public static final Version V_2_1_0 = new Version(2010099, org.apache.lucene.util.Version.LUCENE_9_2_0);
    public static final Version V_2_1_1 = new Version(2010199, org.apache.lucene.util.Version.LUCENE_9_2_0);
    public static final Version V_2_2_0 = new Version(2020099, org.apache.lucene.util.Version.LUCENE_9_3_0);
    public static final Version V_2_2_1 = new Version(2020199, org.apache.lucene.util.Version.LUCENE_9_3_0);
    public static final Version V_2_2_2 = new Version(2020299, org.apache.lucene.util.Version.LUCENE_9_3_0);
    public static final Version V_2_3_0 = new Version(2030099, org.apache.lucene.util.Version.LUCENE_9_3_0);
    public static final Version V_2_3_1 = new Version(2030199, org.apache.lucene.util.Version.LUCENE_9_3_0);
    public static final Version V_2_4_0 = new Version(2040099, org.apache.lucene.util.Version.LUCENE_9_4_1);
    public static final Version V_2_4_1 = new Version(2040199, org.apache.lucene.util.Version.LUCENE_9_4_2);
    public static final Version V_2_4_2 = new Version(2040299, org.apache.lucene.util.Version.LUCENE_9_4_2);
    public static final Version V_2_5_0 = new Version(2050099, org.apache.lucene.util.Version.LUCENE_9_4_2);
    public static final Version V_2_5_1 = new Version(2050199, org.apache.lucene.util.Version.LUCENE_9_4_2);
    public static final Version V_2_6_0 = new Version(2060099, org.apache.lucene.util.Version.LUCENE_9_5_0);
    public static final Version V_2_6_1 = new Version(2060199, org.apache.lucene.util.Version.LUCENE_9_5_0);
    public static final Version V_2_7_0 = new Version(2070099, org.apache.lucene.util.Version.LUCENE_9_5_0);
    public static final Version V_2_7_1 = new Version(2070199, org.apache.lucene.util.Version.LUCENE_9_5_0);
    public static final Version V_2_8_0 = new Version(2080099, org.apache.lucene.util.Version.LUCENE_9_6_0);
    public static final Version V_2_8_1 = new Version(2080199, org.apache.lucene.util.Version.LUCENE_9_6_0);
    public static final Version V_2_9_0 = new Version(2090099, org.apache.lucene.util.Version.LUCENE_9_7_0);
    public static final Version V_2_9_1 = new Version(2090199, org.apache.lucene.util.Version.LUCENE_9_7_0);
    public static final Version V_2_10_0 = new Version(2100099, org.apache.lucene.util.Version.LUCENE_9_7_0);
    public static final Version V_2_10_1 = new Version(2100199, org.apache.lucene.util.Version.LUCENE_9_7_0);
    public static final Version V_2_11_0 = new Version(2110099, org.apache.lucene.util.Version.LUCENE_9_7_0);
    public static final Version V_2_11_1 = new Version(2110199, org.apache.lucene.util.Version.LUCENE_9_7_0);
    public static final Version V_2_11_2 = new Version(2110299, org.apache.lucene.util.Version.LUCENE_9_7_0);
    public static final Version V_2_12_0;
    public static final Version CURRENT;
    public static final int MASK = 0x8000000;
    public final int id;
    public final byte major;
    public final byte minor;
    public final byte revision;
    public final byte build;
    public final org.apache.lucene.util.Version luceneVersion;
    private Version minCompatVersion;
    private Version minIndexCompatVersion;

    public static Version fromId(int id) {
        Version known = LegacyESVersion.idToVersion.get(id);
        if (known != null) {
            return known;
        }
        return Version.fromIdSlow(id);
    }

    private static Version fromIdSlow(int id) {
        List<Version> versions = DeclaredVersionsHolder.DECLARED_VERSIONS;
        Version tmp = id < 0x8000000 ? new LegacyESVersion(id, org.apache.lucene.util.Version.LATEST) : new Version(id ^ 0x8000000, org.apache.lucene.util.Version.LATEST);
        int index = Collections.binarySearch(versions, tmp);
        if (index < 0) {
            index = -2 - index;
        } else assert (false) : "Version [" + String.valueOf(tmp) + "] is declared but absent from the switch statement in Version#fromId";
        org.apache.lucene.util.Version luceneVersion = index == -1 ? org.apache.lucene.util.Version.fromBits((int)(versions.get((int)0).luceneVersion.major - 1), (int)0, (int)0) : versions.get((int)index).luceneVersion;
        return id < 0x8000000 ? new LegacyESVersion(id, luceneVersion) : new Version(id ^ 0x8000000, luceneVersion);
    }

    public static int computeLegacyID(int major, int minor, int revision, int build) {
        return major * 1000000 + minor * 10000 + revision * 100 + build;
    }

    public static int computeID(int major, int minor, int revision, int build) {
        return Version.computeLegacyID(major, minor, revision, build) ^ 0x8000000;
    }

    public static Version min(Version version1, Version version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static Version max(Version version1, Version version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static Version fromString(String version) {
        if (!Version.stringHasLength(version)) {
            return CURRENT;
        }
        Version cached = LegacyESVersion.stringToVersion.get(version);
        if (cached != null) {
            return cached;
        }
        String[] parts = version.split("[.-]");
        if (parts.length < 3 || parts.length > 4) {
            throw new IllegalArgumentException("the version needs to contain major, minor, and revision, and optionally the build: " + version);
        }
        int major = Integer.parseInt(parts[0]);
        if (major > 3) {
            return LegacyESVersion.fromStringSlow(version);
        }
        return Version.fromStringSlow(version);
    }

    private static Version fromStringSlow(String version) {
        if (version.endsWith("-SNAPSHOT")) {
            throw new IllegalArgumentException("illegal version format - snapshot labels are not supported");
        }
        String[] parts = version.split("[.-]");
        if (parts.length < 3 || parts.length > 4) {
            throw new IllegalArgumentException("the version needs to contain major, minor, and revision, and optionally the build: " + version);
        }
        try {
            int rawMajor = Integer.parseInt(parts[0]);
            int betaOffset = 25;
            int major = rawMajor * 1000000;
            int minor = Integer.parseInt(parts[1]) * 10000;
            int revision = Integer.parseInt(parts[2]) * 100;
            int build = 99;
            if (parts.length == 4) {
                String buildStr = parts[3];
                if (buildStr.startsWith("alpha")) {
                    build = Integer.parseInt(buildStr.substring(5));
                    assert (build < 25) : "expected a alpha build but " + build + " >= 25";
                } else if (buildStr.startsWith("Beta") || buildStr.startsWith("beta")) {
                    build = 25 + Integer.parseInt(buildStr.substring(4));
                    assert (build < 50) : "expected a beta build but " + build + " >= 50";
                } else if (buildStr.startsWith("RC") || buildStr.startsWith("rc")) {
                    build = Integer.parseInt(buildStr.substring(2)) + 50;
                } else {
                    throw new IllegalArgumentException("unable to parse version " + version);
                }
            }
            return Version.fromId(major + minor + revision + build ^ 0x8000000);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse version " + version, e);
        }
    }

    Version(int id, org.apache.lucene.util.Version luceneVersion) {
        if (id != 0) {
            this.id = id ^ 0x8000000;
            id &= 0xF7FFFFFF;
        } else {
            this.id = id;
        }
        this.major = (byte)(id / 1000000 % 100);
        this.minor = (byte)(id / 10000 % 100);
        this.revision = (byte)(id / 100 % 100);
        this.build = (byte)(id % 100);
        this.luceneVersion = Objects.requireNonNull(luceneVersion);
    }

    public boolean after(Version version) {
        return version.id < this.id;
    }

    public boolean onOrAfter(Version version) {
        return version.id <= this.id;
    }

    public boolean before(Version version) {
        return version.id > this.id;
    }

    public boolean onOrBefore(Version version) {
        return version.id >= this.id;
    }

    public int compareMajor(Version other) {
        if (this.major == 7 || other.major == 7 || this.major == 6 || other.major == 6) {
            int m;
            int n = this.major == 1 ? 7 : (m = this.major == 2 ? 8 : (int)this.major);
            int om = other.major == 1 ? 7 : (other.major == 2 ? 8 : (int)other.major);
            return Integer.compare(m, om);
        }
        return Integer.compare(this.major, other.major);
    }

    @Override
    public int compareTo(Version other) {
        return Integer.compare(this.id, other.id);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    public Version minimumCompatibilityVersion() {
        Version res = this.minCompatVersion;
        if (res == null) {
            this.minCompatVersion = res = this.computeMinCompatVersion();
        }
        return res;
    }

    protected Version computeMinCompatVersion() {
        if (this.major == 1 || this.major == 7) {
            return LegacyESVersion.fromId(6080099);
        }
        if (this.major == 2) {
            return LegacyESVersion.V_7_10_0;
        }
        if (this.major == 6) {
            return LegacyESVersion.fromId(5060099);
        }
        if (this.major >= 3 && this.major < 5) {
            Version bwcVersion = null;
            for (int i = DeclaredVersionsHolder.DECLARED_VERSIONS.size() - 1; i >= 0; --i) {
                Version candidateVersion = DeclaredVersionsHolder.DECLARED_VERSIONS.get(i);
                if (candidateVersion.major != this.major - 1 || !candidateVersion.isRelease() || !this.after(candidateVersion)) continue;
                if (bwcVersion != null && candidateVersion.minor < bwcVersion.minor) break;
                bwcVersion = candidateVersion;
            }
            return bwcVersion == null ? this : bwcVersion;
        }
        return Version.min(this, Version.fromId(this.maskId(this.major * 1000000 + 0 + 99)));
    }

    protected int maskId(int id) {
        return 0x8000000 ^ id;
    }

    public Version minimumIndexCompatibilityVersion() {
        Version res = this.minIndexCompatVersion;
        if (res == null) {
            this.minIndexCompatVersion = res = this.computeMinIndexCompatVersion();
        }
        return res;
    }

    private Version computeMinIndexCompatVersion() {
        int bwcMajor;
        if (this.major == 5) {
            bwcMajor = 2;
        } else {
            if (this.major == 7 || this.major == 1) {
                return LegacyESVersion.fromId(6000026);
            }
            if (this.major == 2) {
                return LegacyESVersion.V_7_0_0;
            }
            bwcMajor = this.major - 1;
        }
        boolean bwcMinor = false;
        if (this.major == 3) {
            return Version.min(this, Version.fromId(bwcMajor * 1000000 + 0 + 99 ^ 0x8000000));
        }
        return Version.min(this, Version.fromId(bwcMajor * 1000000 + 0 + 99));
    }

    public boolean isCompatible(Version version) {
        boolean compatible = this.onOrAfter(version.minimumCompatibilityVersion()) && version.onOrAfter(this.minimumCompatibilityVersion());
        int a = this.major;
        int b = version.major;
        if (a == 7 || b == 7 || a == 6 || b == 6) {
            if (this.major <= 2) {
                a += 6;
            }
            if (version.major <= 2) {
                b += 6;
            }
        }
        assert (!compatible || Math.max(a, b) - Math.min(a, b) <= 1);
        return compatible;
    }

    @SuppressForbidden(reason="System.out.*")
    public static void main(String[] args) {
        String versionOutput = String.format(Locale.ROOT, "Version: %s, Build: %s/%s/%s/%s, JVM: %s", Build.CURRENT.getQualifiedVersion(), Build.CURRENT.type().displayName(), Build.CURRENT.hash(), Build.CURRENT.date(), System.getProperty("java.version"));
        System.out.println(versionOutput);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.revision);
        if (this.isAlpha()) {
            sb.append("-alpha");
            sb.append(this.build);
        } else if (this.isBeta()) {
            sb.append("-beta");
            sb.append(this.build - 25);
        } else if (this.build < 99) {
            sb.append("-rc");
            sb.append(this.build - 50);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.id == version.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isBeta() {
        return this.build >= 25 && this.build < 50;
    }

    public boolean isAlpha() {
        return this.build < 25;
    }

    public boolean isRC() {
        return this.build > 50 && this.build < 99;
    }

    public boolean isRelease() {
        return this.build == 99;
    }

    public static List<Version> getDeclaredVersions(Class<?> versionClass) {
        Field[] fields = versionClass.getFields();
        ArrayList<Version> versions = new ArrayList<Version>(fields.length);
        block9: for (Field field : fields) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) && Modifier.isFinal(mod) && Modifier.isPublic(mod) || field.getType() != Version.class && field.getType() != LegacyESVersion.class) continue;
            switch (field.getName()) {
                case "CURRENT": 
                case "V_EMPTY": {
                    continue block9;
                }
                default: {
                    assert (field.getName().matches("V(_\\d+)+(_(alpha|beta|rc)\\d+)?")) : field.getName();
                    try {
                        versions.add((Version)field.get(null));
                        continue block9;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        Collections.sort(versions);
        return versions;
    }

    public static boolean stringHasLength(String str) {
        return str != null && str.length() > 0;
    }

    static {
        CURRENT = V_2_12_0 = new Version(2120099, org.apache.lucene.util.Version.LUCENE_9_9_2);
    }

    static class DeclaredVersionsHolder {
        protected static final List<Version> DECLARED_VERSIONS = Collections.unmodifiableList(Version.getDeclaredVersions(LegacyESVersion.class));

        DeclaredVersionsHolder() {
        }
    }
}

