/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.round;

import jdk.incubator.vector.LongVector;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.round.BidirectionalLinearSearcher;
import org.opensearch.common.round.BinarySearcher;
import org.opensearch.common.round.BtreeSearcher;
import org.opensearch.common.round.Roundable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@InternalApi
public final class RoundableFactory {
    private static final int LINEAR_SEARCH_MAX_SIZE = 64;
    private static final boolean USE_BTREE_SEARCHER;

    private RoundableFactory() {
    }

    public static Roundable create(long[] values, int size) {
        if (size <= 64) {
            return new BidirectionalLinearSearcher(values, size);
        }
        if (USE_BTREE_SEARCHER) {
            return new BtreeSearcher(values, size);
        }
        return new BinarySearcher(values, size);
    }

    static {
        String simdRoundingFeatureFlag = System.getProperty("opensearch.experimental.feature.simd.rounding.enabled");
        boolean useBtreeSearcher = false;
        try {
            Class<?> incubator = Class.forName("jdk.incubator.vector.LongVector");
            useBtreeSearcher = "forced".equalsIgnoreCase(simdRoundingFeatureFlag) || VectorCheck.SPECIES_PREFERRED >= 4 && "true".equalsIgnoreCase(simdRoundingFeatureFlag);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        USE_BTREE_SEARCHER = useBtreeSearcher;
    }

    private static final class VectorCheck {
        static final int SPECIES_PREFERRED = LongVector.SPECIES_PREFERRED.length();

        private VectorCheck() {
        }
    }
}

