/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.LongHash;
import org.opensearch.common.util.ReorganizingLongHash;

@Fork(value=3)
@Warmup(iterations=1, time=4)
@Measurement(iterations=3, time=2)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class LongHashBenchmark {
    @Benchmark
    public void add(Blackhole bh, HashTableOptions tableOpts, WorkloadOptions workloadOpts) {
        try (HashTable table = tableOpts.get();
             WorkloadIterator iter = workloadOpts.iter();){
            while (iter.hasNext()) {
                bh.consume(table.add(iter.next()));
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class HashTableOptions {
        @Param(value={"LongHash", "ReorganizingLongHash"})
        public String type;
        @Param(value={"1"})
        public long initialCapacity;
        @Param(value={"0.6"})
        public float loadFactor;
        private Supplier<HashTable> supplier;

        @Setup
        public void setup() {
            switch (this.type) {
                case "LongHash": {
                    this.supplier = this::newLongHash;
                    break;
                }
                case "ReorganizingLongHash": {
                    this.supplier = this::newReorganizingLongHash;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid hash table type: " + this.type);
                }
            }
        }

        public HashTable get() {
            return this.supplier.get();
        }

        private HashTable newLongHash() {
            return new HashTable(){
                private final LongHash table;
                {
                    this.table = new LongHash(initialCapacity, loadFactor, BigArrays.NON_RECYCLING_INSTANCE);
                }

                @Override
                public long add(long key) {
                    return this.table.add(key);
                }

                public void close() {
                    this.table.close();
                }
            };
        }

        private HashTable newReorganizingLongHash() {
            return new HashTable(){
                private final ReorganizingLongHash table;
                {
                    this.table = new ReorganizingLongHash(initialCapacity, loadFactor, BigArrays.NON_RECYCLING_INSTANCE);
                }

                @Override
                public long add(long key) {
                    return this.table.add(key);
                }

                public void close() {
                    this.table.close();
                }
            };
        }
    }

    private static interface HashTable
    extends Releasable {
        public long add(long var1);
    }

    @State(value=Scope.Benchmark)
    public static class WorkloadOptions {
        public static final int NUM_HITS = 20000000;
        @Param(value={"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "13", "15", "17", "18", "19", "20", "21", "23", "26", "27", "30", "32", "35", "41", "45", "50", "53", "54", "55", "57", "63", "64", "69", "74", "80", "84", "91", "98", "101", "111", "114", "124", "128", "139", "148", "161", "162", "176", "190", "204", "216", "240", "257", "269", "291", "302", "308", "327", "341", "374", "402", "412", "438", "443", "488", "505", "558", "612", "621", "623", "627", "642", "717", "765", "787", "817", "915", "962", "1011", "1083", "1163", "1237", "1301", "1424", "1541", "1716", "1805", "1817", "1934", "2024", "2238", "2281", "2319", "2527", "2583", "2639", "2662", "2692", "2991", "3201", "3215", "3517", "3681", "3710", "4038", "4060", "4199", "4509", "4855", "5204", "5624", "6217", "6891", "7569", "8169", "8929", "9153", "10005", "10624", "10931", "12070", "12370", "13694", "14227", "15925", "17295", "17376", "18522", "19200", "20108", "21496", "23427", "24224", "26759", "29199", "29897", "32353", "33104", "36523", "38480", "38958", "40020", "44745", "45396", "47916", "49745", "49968", "52231", "53606"})
        public int size;
        @Param(value={"correlated", "uncorrelated", "distinct"})
        public String dataset;
        private WorkloadIterator iterator;

        @Setup
        public void setup() {
            switch (this.dataset) {
                case "correlated": {
                    this.iterator = this.newCorrelatedWorkload();
                    break;
                }
                case "uncorrelated": {
                    this.iterator = this.newUncorrelatedWorkload();
                    break;
                }
                case "distinct": {
                    this.iterator = this.newDistinctWorkload();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid dataset: " + this.dataset);
                }
            }
        }

        public WorkloadIterator iter() {
            return this.iterator;
        }

        private WorkloadIterator newCorrelatedWorkload() {
            assert (20000000 >= this.size) : "ensure hits >= size so that each key is used at least once";
            final long[] data = new long[this.size];
            for (int i = 0; i < data.length; ++i) {
                data[i] = 1420070400000L + 3600000L * (long)i;
            }
            return new WorkloadIterator(){
                private int count = 0;
                private int index = 0;
                private int remaining = 20000000 / data.length;

                @Override
                public boolean hasNext() {
                    return this.count < 20000000;
                }

                @Override
                public long next() {
                    if (--this.remaining <= 0) {
                        this.index = (this.index + 1) % data.length;
                        this.remaining = 20000000 / data.length;
                    }
                    ++this.count;
                    return data[this.index];
                }

                @Override
                public void reset() {
                    this.count = 0;
                    this.index = 0;
                    this.remaining = 20000000 / data.length;
                }
            };
        }

        private WorkloadIterator newUncorrelatedWorkload() {
            assert (20000000 >= this.size) : "ensure hits >= size so that each key is used at least once";
            Random random = new Random(0L);
            final long[] data = new long[this.size];
            for (int i = 0; i < data.length; ++i) {
                data[i] = Double.doubleToLongBits(20.0 + 80.0 * random.nextDouble());
            }
            return new WorkloadIterator(){
                private int count = 0;
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.count < 20000000;
                }

                @Override
                public long next() {
                    ++this.count;
                    this.index = (this.index + 1) % data.length;
                    return data[this.index];
                }

                @Override
                public void reset() {
                    this.count = 0;
                    this.index = 0;
                }
            };
        }

        private WorkloadIterator newDistinctWorkload() {
            return new WorkloadIterator(){
                private int count = 0;

                @Override
                public boolean hasNext() {
                    return this.count < size;
                }

                @Override
                public long next() {
                    return this.count++;
                }

                @Override
                public void reset() {
                    this.count = 0;
                }
            };
        }
    }

    private static interface WorkloadIterator
    extends Releasable {
        public boolean hasNext();

        public long next();

        public void reset();

        default public void close() {
            this.reset();
        }
    }
}

