/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.opensearch.common.hash.T1ha1;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.BytesRefHash;

@Fork(value=3)
@Warmup(iterations=1, time=2)
@Measurement(iterations=3, time=5)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class BytesRefHashBenchmark {
    private static final int NUM_TABLES = 20;
    private static final int NUM_HITS = 1000000;

    @Benchmark
    public void add(Blackhole bh, Options opts) {
        Releasable[] tables = (HashTable[])Stream.generate(opts.type::create).limit(20L).toArray(HashTable[]::new);
        for (int hit = 0; hit < 1000000; ++hit) {
            BytesRef key = opts.keys[hit % opts.keys.length];
            for (Releasable table : tables) {
                bh.consume(table.add(key));
            }
        }
        Releasables.close((Releasable[])tables);
    }

    @State(value=Scope.Benchmark)
    public static class Options {
        @Param(value={"MURMUR3", "T1HA1"})
        public Type type;
        @Param(value={"1", "2", "3", "4", "5", "6", "7", "8", "10", "12", "14", "16", "19", "22", "25", "29", "33", "38", "43", "50", "57", "65", "75", "86", "97", "109", "124", "141", "161", "182", "204", "229", "262", "297", "336", "380", "430", "482", "550", "610", "704", "801", "914", "1042", "1178", "1343", "1532", "1716", "1940", "2173", "2456", "2751", "3082", "3514", "4006", "4487", "5026", "5730", "6418", "7317", "8196", "9180", "10374", "11723", "13247", "14837", "16915", "19114", "21599", "24623", "28071", "32001", "36482", "41590", "46581", "52637", "58954", "67208", "76618", "86579", "97835", "109576", "122726", "138681", "156710", "175516", "198334", "222135", "248792", "281135", "320494", "365364", "409208", "466498", "527143", "595672", "667153", "753883", "851888", "971153"})
        public Integer size;
        @Param(value={"5", "28", "59", "105"})
        public Integer length;
        private BytesRef[] keys;

        @Setup
        public void setup() {
            assert ((double)this.size.intValue() <= Math.pow(26.0, this.length.intValue())) : "key length too small to generate the required number of keys";
            Random random = new Random(this.size.intValue());
            HashSet<BytesRef> seen = new HashSet<BytesRef>();
            this.keys = new BytesRef[this.size.intValue()];
            for (int i = 0; i < this.size; ++i) {
                BytesRef key;
                while (seen.contains(key = new BytesRef((CharSequence)random.ints(97, 123).limit(this.length.intValue()).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString()))) {
                }
                this.keys[i] = key;
                seen.add(key);
            }
        }
    }

    public static enum Type {
        MURMUR3(() -> new HashTable(){
            private final BytesRefHash table = new BytesRefHash(1L, 0.6f, key -> {
                long h = (long)StringHelper.murmurhash3_x86_32((byte[])key.bytes, (int)key.offset, (int)key.length, (int)0) & 0xFFFFFFFFL;
                return h | h << 32;
            }, BigArrays.NON_RECYCLING_INSTANCE);

            @Override
            public long add(BytesRef key) {
                return this.table.add(key);
            }

            public void close() {
                this.table.close();
            }
        }),
        T1HA1(() -> new HashTable(){
            private final BytesRefHash table = new BytesRefHash(1L, 0.6f, key -> T1ha1.hash((byte[])key.bytes, (int)key.offset, (int)key.length, (long)0L), BigArrays.NON_RECYCLING_INSTANCE);

            @Override
            public long add(BytesRef key) {
                return this.table.add(key);
            }

            public void close() {
                this.table.close();
            }
        });

        private final Supplier<HashTable> supplier;

        private Type(Supplier<HashTable> supplier) {
            this.supplier = supplier;
        }

        public HashTable create() {
            return this.supplier.get();
        }
    }

    static interface HashTable
    extends Releasable {
        public long add(BytesRef var1);
    }
}

