/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.round;

import java.util.function.Supplier;
import org.opensearch.common.round.BidirectionalLinearSearcher;
import org.opensearch.common.round.BinarySearcher;
import org.opensearch.common.round.BtreeSearcher;
import org.opensearch.common.round.Roundable;

public class RoundableSupplier
implements Supplier<Roundable> {
    private final Supplier<Roundable> delegate;

    RoundableSupplier(String type, long[] values, int size) {
        switch (type) {
            case "binary": {
                this.delegate = () -> new BinarySearcher(values, size);
                break;
            }
            case "linear": {
                this.delegate = () -> new BidirectionalLinearSearcher(values, size);
                break;
            }
            case "btree": {
                this.delegate = () -> new BtreeSearcher(values, size);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type: " + type);
            }
        }
    }

    @Override
    public Roundable get() {
        return this.delegate.get();
    }
}

