/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.round;

import java.util.Random;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.opensearch.common.round.Roundable;
import org.opensearch.common.round.RoundableSupplier;

@Fork(value=3)
@Warmup(iterations=3, time=1)
@Measurement(iterations=1, time=1)
@BenchmarkMode(value={Mode.Throughput})
public class RoundableBenchmark {
    @Benchmark
    public void floor(Blackhole bh, Options opts) {
        Roundable roundable = opts.supplier.get();
        for (long key : opts.queries) {
            bh.consume(roundable.floor(key));
        }
    }

    @State(value=Scope.Benchmark)
    public static class Options {
        @Param(value={"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "12", "14", "16", "18", "20", "22", "24", "26", "29", "32", "37", "41", "45", "49", "54", "60", "64", "74", "83", "90", "98", "108", "118", "128", "144", "159", "171", "187", "204", "229", "256"})
        public Integer size;
        @Param(value={"binary", "linear", "btree"})
        public String type;
        @Param(value={"uniform", "skewed_edge", "skewed_center"})
        public String distribution;
        public long[] queries;
        public RoundableSupplier supplier;

        @Setup
        public void setup() throws ClassNotFoundException {
            Random random = new Random(this.size.intValue());
            long[] values = new long[this.size.intValue()];
            for (int i = 1; i < values.length; ++i) {
                values[i] = values[i - 1] + 100L;
            }
            long range = values[values.length - 1] - values[0] + 100L;
            this.queries = new long[1000000];
            switch (this.distribution) {
                case "uniform": {
                    for (int i = 0; i < this.queries.length; ++i) {
                        this.queries[i] = values[0] + Options.nextPositiveLong(random) % range;
                    }
                    break;
                }
                case "skewed_edge": {
                    long mean = values[0] + (long)((double)range * 0.9);
                    long stddev = (long)((double)range * 0.05);
                    for (int i = 0; i < this.queries.length; ++i) {
                        this.queries[i] = Math.max(values[0], mean + (long)(random.nextGaussian() * (double)stddev));
                    }
                    break;
                }
                case "skewed_center": {
                    long mean = values[0] + (long)((double)range * 0.5);
                    long stddev = (long)((double)range * 0.05);
                    for (int i = 0; i < this.queries.length; ++i) {
                        this.queries[i] = Math.max(values[0], mean + (long)(random.nextGaussian() * (double)stddev));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid distribution: " + this.distribution);
                }
            }
            this.supplier = new RoundableSupplier(this.type, values, this.size);
        }

        private static long nextPositiveLong(Random random) {
            return random.nextLong() & Long.MAX_VALUE;
        }
    }
}

