/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common;

import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.opensearch.common.Rounding;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;

@Fork(value=2)
@Warmup(iterations=10)
@Measurement(iterations=5)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Benchmark)
public class RoundingBenchmark {
    private static final DateFormatter FORMATTER = DateFormatter.forPattern((String)"date_optional_time");
    @Param(value={"2000-01-01 to 2020-01-01", "2000-10-01 to 2000-11-01", "2000-10-29 to 2000-10-30", "2000-06-01 to 2000-06-02"})
    public String range;
    @Param(value={"java time", "es"})
    public String rounder;
    @Param(value={"UTC", "America/New_York"})
    public String zone;
    @Param(value={"calendar year", "calendar hour", "10d", "5d", "1h"})
    public String interval;
    @Param(value={"1", "10000", "1000000", "100000000"})
    public int count;
    private long min;
    private long max;
    private long[] dates;
    private Supplier<Rounding.Prepared> rounderBuilder;

    @Setup
    public void buildDates() {
        String[] r = this.range.split(" to ");
        this.min = FORMATTER.parseMillis(r[0]);
        this.max = FORMATTER.parseMillis(r[1]);
        this.dates = new long[this.count];
        long date = this.min;
        long diff = (this.max - this.min) / (long)this.dates.length;
        for (int i = 0; i < this.dates.length; ++i) {
            if (date >= this.max) {
                throw new IllegalStateException("made a bad date [" + date + "]");
            }
            this.dates[i] = date;
            date += diff;
        }
        Rounding.Builder roundingBuilder = this.interval.startsWith("calendar ") ? Rounding.builder((Rounding.DateTimeUnit)((Rounding.DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(this.interval.substring("calendar ".length())))) : Rounding.builder((TimeValue)TimeValue.parseTimeValue((String)this.interval, (String)"interval"));
        Rounding rounding = roundingBuilder.timeZone(ZoneId.of(this.zone)).build();
        switch (this.rounder) {
            case "java time": {
                this.rounderBuilder = () -> ((Rounding)rounding).prepareJavaTime();
                break;
            }
            case "es": {
                this.rounderBuilder = () -> rounding.prepare(this.min, this.max);
                break;
            }
            default: {
                throw new IllegalArgumentException("Expectd rounder to be [java time] or [es]");
            }
        }
    }

    @Benchmark
    public void round(Blackhole bh) {
        Rounding.Prepared rounder = this.rounderBuilder.get();
        for (int i = 0; i < this.dates.length; ++i) {
            bh.consume(rounder.round(this.dates[i]));
        }
    }

    @Benchmark
    public void nextRoundingValue(Blackhole bh) {
        Rounding.Prepared rounder = this.rounderBuilder.get();
        for (int i = 0; i < this.dates.length; ++i) {
            bh.consume(rounder.nextRoundingValue(this.dates[i]));
        }
    }
}

