/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.benchmark.time;

import java.time.temporal.TemporalAccessor;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.opensearch.common.joda.Joda;
import org.opensearch.common.time.DateFormatter;

@Fork(value=3)
@Warmup(iterations=10)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Benchmark)
public class DateFormatterBenchmark {
    private final DateFormatter javaFormatter = DateFormatter.forPattern((String)"8year_month_day||ordinal_date||epoch_millis");
    private final DateFormatter jodaFormatter = Joda.forPattern((String)"year_month_day||ordinal_date||epoch_millis");

    @Benchmark
    public TemporalAccessor parseJavaDate() {
        return this.javaFormatter.parse("1234567890");
    }

    @Benchmark
    public TemporalAccessor parseJodaDate() {
        return this.jodaFormatter.parse("1234567890");
    }
}

