/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.benchmark.store.remote.filecache;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.store.IndexInput;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.opensearch.index.store.remote.filecache.CachedIndexInput;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.index.store.remote.filecache.FileCacheFactory;

@Warmup(iterations=1)
@Measurement(iterations=1)
@Fork(value=1)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Thread)
@Threads(value=8)
public class FileCacheBenchmark {
    private static final CachedIndexInput INDEX_INPUT = new FixedSizeStubIndexInput();

    @Benchmark
    public void get(CacheParameters parameters, Blackhole blackhole) {
        blackhole.consume((Object)parameters.fileCache.get(FileCacheBenchmark.randomKeyInCache(parameters)));
    }

    @Benchmark
    public void replace(CacheParameters parameters, Blackhole blackhole) {
        blackhole.consume((Object)parameters.fileCache.put(FileCacheBenchmark.randomKeyInCache(parameters), INDEX_INPUT));
    }

    @Benchmark
    public void put(CacheParameters parameters, Blackhole blackhole) {
        blackhole.consume((Object)parameters.fileCache.put(FileCacheBenchmark.randomKeyNotInCache(parameters), INDEX_INPUT));
    }

    @Benchmark
    public void remove(CacheParameters parameters) {
        parameters.fileCache.remove(FileCacheBenchmark.randomKeyInCache(parameters));
    }

    private static Path randomKeyInCache(CacheParameters parameters) {
        int i = ThreadLocalRandom.current().nextInt(parameters.maximumNumberOfEntries);
        return Paths.get(Integer.toString(i), new String[0]);
    }

    private static Path randomKeyNotInCache(CacheParameters parameters) {
        int i = ThreadLocalRandom.current().nextInt(parameters.maximumNumberOfEntries, parameters.maximumNumberOfEntries * 2);
        return Paths.get(Integer.toString(i), new String[0]);
    }

    @State(value=Scope.Benchmark)
    public static class CacheParameters {
        @Param(value={"65536", "1048576"})
        int maximumNumberOfEntries;
        @Param(value={"1", "8"})
        int concurrencyLevel;
        FileCache fileCache;

        @Setup
        public void setup() {
            this.fileCache = FileCacheFactory.createConcurrentLRUFileCache((long)((long)this.maximumNumberOfEntries * INDEX_INPUT.length()), (int)this.concurrencyLevel);
            for (long i = 0L; i < (long)this.maximumNumberOfEntries; ++i) {
                Path key = Paths.get(Long.toString(i), new String[0]);
                this.fileCache.put(key, INDEX_INPUT);
                this.fileCache.decRef(key);
            }
        }
    }

    private static class FixedSizeStubIndexInput
    implements CachedIndexInput {
        private FixedSizeStubIndexInput() {
        }

        public IndexInput getIndexInput() {
            return null;
        }

        public long length() {
            return 0x800000L;
        }

        public boolean isClosed() {
            return false;
        }

        public void close() throws Exception {
        }
    }
}

