/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.benchmark.search.sort;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Fork(value=3)
@Warmup(iterations=5)
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
public class ShardDocComparatorBenchmark {
    @Param(value={"1", "4", "16"})
    public int segments;
    @Param(value={"50000"})
    public int docsPerSegment;
    @Param(value={"7"})
    public int shardId;
    private long shardKeyPrefix;
    private int[] docBases;
    private int[] docs;
    private long[] keys;
    private int[] globalDocs;

    @Setup
    public void setup() {
        this.shardKeyPrefix = (long)this.shardId << 32;
        this.docBases = new int[this.segments];
        for (int i = 1; i < this.segments; ++i) {
            this.docBases[i] = this.docBases[i - 1] + this.docsPerSegment;
        }
        int total = this.segments * this.docsPerSegment;
        this.docs = new int[total];
        this.keys = new long[total];
        this.globalDocs = new int[total];
        Random r = new Random(42L);
        int pos = 0;
        for (int s = 0; s < this.segments; ++s) {
            int base = this.docBases[s];
            for (int d = 0; d < this.docsPerSegment; ++d) {
                int doc;
                this.docs[pos] = doc = r.nextInt(this.docsPerSegment);
                this.keys[pos] = this.computeGlobalDocKey(base, doc);
                this.globalDocs[pos] = base + doc;
                ++pos;
            }
        }
    }

    @Benchmark
    public long compareDocOnlyAsc() {
        long acc = 0L;
        for (int i = 1; i < this.globalDocs.length; ++i) {
            acc += (long)Integer.compare(this.globalDocs[i - 1], this.globalDocs[i]);
        }
        return acc;
    }

    @Benchmark
    public void packKey(Blackhole bh) {
        int total = this.segments * this.docsPerSegment;
        int idx = 0;
        for (int s = 0; s < this.segments; ++s) {
            int base = this.docBases[s];
            for (int d = 0; d < this.docsPerSegment; ++d) {
                long k = this.computeGlobalDocKey(base, this.docs[idx++]);
                bh.consume(k);
            }
        }
    }

    @Benchmark
    public long compareAsc() {
        long acc = 0L;
        for (int i = 1; i < this.keys.length; ++i) {
            acc += (long)Long.compare(this.keys[i - 1], this.keys[i]);
        }
        return acc;
    }

    @Benchmark
    public long compareDesc() {
        long acc = 0L;
        for (int i = 1; i < this.keys.length; ++i) {
            acc += (long)Long.compare(this.keys[i], this.keys[i - 1]);
        }
        return acc;
    }

    @Benchmark
    public int copyAndCompareBottomAsc() {
        long bottom = Long.MIN_VALUE;
        int worse = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            long v = this.keys[i];
            if ((i & 0x1F) == 0) {
                bottom = v;
            }
            if (Long.compare(bottom, v) >= 0) continue;
            ++worse;
        }
        return worse;
    }

    private long computeGlobalDocKey(int docBase, int doc) {
        return this.shardKeyPrefix | (long)(docBase + doc);
    }
}

