/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.benchmark.search.aggregations.bucket.terms;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.BytesRef;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.opensearch.common.io.stream.DelayableWriteable;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.bucket.terms.StringTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;

@Fork(value=2)
@Warmup(iterations=10)
@Measurement(iterations=5)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
public class StringTermsSerializationBenchmark {
    private static final NamedWriteableRegistry REGISTRY = new NamedWriteableRegistry(List.of(new NamedWriteableRegistry.Entry(InternalAggregation.class, "sterms", StringTerms::new)));
    @Param(value={"1000"})
    private int buckets;
    private DelayableWriteable<InternalAggregations> results;

    @Setup
    public void initResults() {
        this.results = DelayableWriteable.referencing((Writeable)InternalAggregations.from(List.of(this.newTerms(true))));
    }

    private StringTerms newTerms(boolean withNested) {
        ArrayList<StringTerms.Bucket> resultBuckets = new ArrayList<StringTerms.Bucket>(this.buckets);
        for (int i = 0; i < this.buckets; ++i) {
            InternalAggregations inner = withNested ? InternalAggregations.from(List.of(this.newTerms(false))) : InternalAggregations.EMPTY;
            resultBuckets.add(new StringTerms.Bucket(new BytesRef((CharSequence)("test" + i)), (long)i, inner, false, 0L, DocValueFormat.RAW));
        }
        return new StringTerms("test", BucketOrder.key((boolean)true), BucketOrder.key((boolean)true), null, DocValueFormat.RAW, this.buckets, false, 100000L, resultBuckets, 0L, new TermsAggregator.BucketCountThresholds(1L, 0L, this.buckets, this.buckets));
    }

    @Benchmark
    public DelayableWriteable<InternalAggregations> serialize() {
        return this.results.asSerialized(InternalAggregations::readFrom, REGISTRY);
    }
}

