/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.benchmark.search.aggregations.bucket.terms;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;

@Fork(value=2)
@Warmup(iterations=10)
@Measurement(iterations=5)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@OperationsPerInvocation(value=1000000)
@State(value=Scope.Benchmark)
public class LongKeyedBucketOrdsBenchmark {
    private static final long LIMIT = 1000000L;
    private static final long DISTINCT_VALUES = 10L;
    private static final long DISTINCT_BUCKETS = 21L;
    private final PageCacheRecycler recycler = new PageCacheRecycler(Settings.EMPTY);
    private final BigArrays bigArrays = new BigArrays(this.recycler, null, "REQUEST");

    @Setup
    public void forceLoadClasses(Blackhole bh) {
        bh.consume(LongKeyedBucketOrds.FromSingle.class);
        bh.consume(LongKeyedBucketOrds.FromMany.class);
    }

    @Benchmark
    public void singleBucketIntoSingleImmutableMonmorphicInvocation(Blackhole bh) {
        try (LongKeyedBucketOrds.FromSingle ords = new LongKeyedBucketOrds.FromSingle(this.bigArrays);){
            for (long i = 0L; i < 1000000L; ++i) {
                ords.add(0L, i % 10L);
            }
            bh.consume((Object)ords);
        }
    }

    @Benchmark
    public void singleBucketIntoSingleImmutableBimorphicInvocation(Blackhole bh) {
        try (LongKeyedBucketOrds ords = LongKeyedBucketOrds.build((BigArrays)this.bigArrays, (CardinalityUpperBound)CardinalityUpperBound.ONE);){
            for (long i = 0L; i < 1000000L; ++i) {
                ords.add(0L, i % 10L);
            }
            bh.consume((Object)ords);
        }
    }

    @Benchmark
    public void singleBucketIntoSingleMutableMonmorphicInvocation(Blackhole bh) {
        LongKeyedBucketOrds.FromSingle ords = new LongKeyedBucketOrds.FromSingle(this.bigArrays);
        for (long i = 0L; i < 1000000L; ++i) {
            if (i % 100000L == 0L) {
                ords.close();
                bh.consume((Object)ords);
                ords = new LongKeyedBucketOrds.FromSingle(this.bigArrays);
            }
            ords.add(0L, i % 10L);
        }
        bh.consume((Object)ords);
        ords.close();
    }

    @Benchmark
    public void singleBucketIntoSingleMutableBimorphicInvocation(Blackhole bh) {
        LongKeyedBucketOrds ords = LongKeyedBucketOrds.build((BigArrays)this.bigArrays, (CardinalityUpperBound)CardinalityUpperBound.ONE);
        for (long i = 0L; i < 1000000L; ++i) {
            if (i % 100000L == 0L) {
                ords.close();
                bh.consume((Object)ords);
                ords = LongKeyedBucketOrds.build((BigArrays)this.bigArrays, (CardinalityUpperBound)CardinalityUpperBound.ONE);
            }
            ords.add(0L, i % 10L);
        }
        bh.consume((Object)ords);
        ords.close();
    }

    @Benchmark
    public void singleBucketIntoMulti(Blackhole bh) {
        try (LongKeyedBucketOrds ords = LongKeyedBucketOrds.build((BigArrays)this.bigArrays, (CardinalityUpperBound)CardinalityUpperBound.MANY);){
            for (long i = 0L; i < 1000000L; ++i) {
                ords.add(0L, i % 10L);
            }
            bh.consume((Object)ords);
        }
    }

    @Benchmark
    public void multiBucket(Blackhole bh) {
        try (LongKeyedBucketOrds ords = LongKeyedBucketOrds.build((BigArrays)this.bigArrays, (CardinalityUpperBound)CardinalityUpperBound.MANY);){
            for (long i = 0L; i < 1000000L; ++i) {
                ords.add(i % 21L, i % 10L);
            }
            bh.consume((Object)ords);
        }
    }
}

