/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.benchmark.routing.allocation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterInfoService;
import org.opensearch.cluster.ClusterModule;
import org.opensearch.cluster.EmptyClusterInfoService;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.opensearch.cluster.routing.allocation.FailedShard;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.opensearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.opensearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.gateway.GatewayAllocator;
import org.opensearch.snapshots.EmptySnapshotsInfoService;
import org.opensearch.snapshots.SnapshotsInfoService;

public final class Allocators {
    private static final AtomicInteger portGenerator = new AtomicInteger();

    private Allocators() {
        throw new AssertionError((Object)"Do not instantiate");
    }

    public static AllocationService createAllocationService(Settings settings) {
        return Allocators.createAllocationService(settings, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
    }

    public static AllocationService createAllocationService(Settings settings, ClusterSettings clusterSettings) {
        return new AllocationService(Allocators.defaultAllocationDeciders(settings, clusterSettings), (GatewayAllocator)NoopGatewayAllocator.INSTANCE, (ShardsAllocator)new BalancedShardsAllocator(settings), (ClusterInfoService)EmptyClusterInfoService.INSTANCE, (SnapshotsInfoService)EmptySnapshotsInfoService.INSTANCE);
    }

    public static AllocationDeciders defaultAllocationDeciders(Settings settings, ClusterSettings clusterSettings) {
        Collection deciders = ClusterModule.createAllocationDeciders((Settings)settings, (ClusterSettings)clusterSettings, Collections.emptyList());
        return new AllocationDeciders(deciders);
    }

    public static DiscoveryNode newNode(String nodeId, Map<String, String> attributes) {
        return new DiscoveryNode("", nodeId, new TransportAddress(TransportAddress.META_ADDRESS, portGenerator.incrementAndGet()), attributes, (Set)Sets.newHashSet((Object[])new DiscoveryNodeRole[]{DiscoveryNodeRole.CLUSTER_MANAGER_ROLE, DiscoveryNodeRole.DATA_ROLE}), Version.CURRENT);
    }

    private static class NoopGatewayAllocator
    extends GatewayAllocator {
        public static final NoopGatewayAllocator INSTANCE = new NoopGatewayAllocator();

        private NoopGatewayAllocator() {
        }

        public void applyStartedShards(List<ShardRouting> startedShards, RoutingAllocation allocation) {
        }

        public void applyFailedShards(List<FailedShard> failedShards, RoutingAllocation allocation) {
        }

        public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
        }
    }
}

