/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.benchmark.routing.allocation;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.opensearch.Version;
import org.opensearch.benchmark.routing.allocation.Allocators;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardRoutingState;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.common.settings.Settings;

@Fork(value=3)
@Warmup(iterations=10)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
public class AllocationBenchmark {
    @Param(value={"       10|      2|        0|       1|      1|      1|", "       10|      3|        0|       1|      1|      2|", "       10|     10|        0|       1|      1|      5|", "      100|      1|        0|       1|      1|     10|", "      100|      3|        0|       1|      1|     10|", "      100|     10|        0|       1|      1|     10|", "       10|      2|        0|      10|     10|      1|", "       10|      3|        0|      10|      5|      2|", "       10|     10|        0|      10|      5|      5|", "      100|      1|        0|       5|     10|      5|", "      100|      3|        0|      10|      5|      5|", "      100|     10|        0|      10|     20|      6|", "       10|      1|        1|      10|     10|      1|", "       10|      3|        1|      10|      3|      3|", "       10|     10|        1|       5|     12|      5|", "      100|      1|        1|      10|     10|      6|", "      100|      3|        1|      10|      5|      8|", "      100|     10|        1|       8|     17|      8|", "       10|      1|        2|      10|     10|      1|", "       10|      3|        2|      10|      5|      3|", "       10|     10|        2|       5|     10|      5|", "      100|      1|        2|      10|      8|      7|", "      100|      3|        2|      13|     17|      5|", "      100|     10|        2|      10|     20|      8|", "       10|      2|        1|      20|     20|      1|", "       10|      3|        1|      20|     30|      1|", "       10|     10|        1|      20|     10|      3|", "      100|      1|        1|      20|      5|      5|", "      100|      3|        1|      20|     23|      6|", "      100|     10|        1|      40|     20|      8|", "       10|      3|        2|      50|     30|      1|", "       10|      3|        2|      50|     25|      1|", "       10|     10|        1|      50|     33|      2|", "      100|      1|        1|      40|     50|      2|", "      100|      3|        1|      50|     70|      3|", "      100|     10|        1|      60|     50|      3|", "       10|     10|        2|      50|     50|      1|", "       10|      3|        2|      50|     30|      1|", "       10|     10|        2|      50|     40|      2|", "      100|      1|        2|      40|     50|      2|", "      100|      3|        2|      50|     30|      6|", "      100|     10|        2|      33|     55|      6|", "       500|     60|       1|     100|    100|     12|", "       500|     60|       1|     100|     40|     12|", "       500|     60|       1|      40|    100|     12|", "       50|      60|       1|     100|    100|      6|", "       50|      60|       1|     100|     40|      6|", "       50|      60|       1|      40|    100|      6|"})
    public String indicesShardsReplicasSourceTargetRecoveries = "10|1|0|1|1|1";
    public int numTags = 2;
    public int numZone = 3;
    public int concurrentRecoveries;
    public int numIndices;
    public int numShards;
    public int numReplicas;
    public int sourceNodes;
    public int targetNodes;
    public int clusterConcurrentRecoveries;
    private AllocationService initialClusterStrategy;
    private AllocationService clusterExcludeStrategy;
    private AllocationService clusterZoneAwareExcludeStrategy;
    private ClusterState initialClusterState;

    @Setup
    public void setUp() throws Exception {
        String[] params = this.indicesShardsReplicasSourceTargetRecoveries.split("\\|");
        this.numIndices = this.toInt(params[0]);
        this.numShards = this.toInt(params[1]);
        this.numReplicas = this.toInt(params[2]);
        this.sourceNodes = this.toInt(params[3]);
        this.targetNodes = this.toInt(params[4]);
        this.concurrentRecoveries = this.toInt(params[5]);
        int totalShardCount = (this.numReplicas + 1) * this.numShards * this.numIndices;
        this.initialClusterStrategy = Allocators.createAllocationService(Settings.builder().put("cluster.routing.allocation.awareness.attributes", "zone").put("cluster.routing.allocation.node_concurrent_recoveries", "20").put("cluster.routing.allocation.exclude.tag", "tag_0").build());
        this.clusterConcurrentRecoveries = Math.min(this.sourceNodes, this.targetNodes) * this.concurrentRecoveries;
        Metadata.Builder mb = Metadata.builder();
        for (int i = 1; i <= this.numIndices; ++i) {
            mb.put(IndexMetadata.builder((String)("test_" + i)).settings(Settings.builder().put("index.version.created", Version.CURRENT)).numberOfShards(this.numShards).numberOfReplicas(this.numReplicas));
        }
        Metadata metadata = mb.build();
        RoutingTable.Builder rb = RoutingTable.builder();
        for (int i = 1; i <= this.numIndices; ++i) {
            rb.addAsNew(metadata.index("test_" + i));
        }
        RoutingTable routingTable = rb.build();
        this.initialClusterState = ClusterState.builder((ClusterName)((ClusterName)ClusterName.CLUSTER_NAME_SETTING.getDefault(Settings.EMPTY))).metadata(metadata).routingTable(routingTable).nodes(this.setUpClusterNodes(this.sourceNodes, this.targetNodes)).build();
        this.initialClusterState = this.initialClusterStrategy.reroute(this.initialClusterState, "reroute");
        while (this.initialClusterState.getRoutingNodes().hasUnassignedShards()) {
            this.initialClusterState = this.initialClusterStrategy.applyStartedShards(this.initialClusterState, this.initialClusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING}));
            this.initialClusterState = this.initialClusterStrategy.reroute(this.initialClusterState, "reroute");
        }
        while (this.initialClusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING}).size() > 0) {
            this.initialClusterState = this.initialClusterStrategy.applyStartedShards(this.initialClusterState, this.initialClusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING}));
        }
        assert (this.initialClusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.STARTED}).size() == totalShardCount);
        assert (this.initialClusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING}).size() == 0);
        assert (this.initialClusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.RELOCATING}).size() == 0);
        for (ShardRouting startedShard : this.initialClusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.STARTED})) {
            assert (((String)this.initialClusterState.getRoutingNodes().node(startedShard.currentNodeId()).node().getAttributes().get("tag")).equals("tag_1"));
        }
    }

    private int toInt(String v) {
        return Integer.valueOf(v.trim());
    }

    @Benchmark
    public ClusterState measureExclusionOnZoneAwareStartedShard() throws Exception {
        ClusterState clusterState = this.initialClusterState;
        this.clusterZoneAwareExcludeStrategy = Allocators.createAllocationService(Settings.builder().put("cluster.routing.allocation.awareness.attributes", "zone").put("cluster.routing.allocation.cluster_concurrent_recoveries", String.valueOf(this.clusterConcurrentRecoveries)).put("cluster.routing.allocation.node_concurrent_recoveries", String.valueOf(this.concurrentRecoveries)).put("cluster.routing.allocation.exclude.tag", "tag_1").build());
        clusterState = this.clusterZoneAwareExcludeStrategy.reroute(clusterState, "reroute");
        return clusterState;
    }

    @Benchmark
    public ClusterState measureShardRelocationComplete() throws Exception {
        ClusterState clusterState = this.initialClusterState;
        this.clusterZoneAwareExcludeStrategy = Allocators.createAllocationService(Settings.builder().put("cluster.routing.allocation.awareness.attributes", "zone").put("cluster.routing.allocation.node_concurrent_recoveries", String.valueOf(this.concurrentRecoveries)).put("cluster.routing.allocation.cluster_concurrent_recoveries", String.valueOf(this.clusterConcurrentRecoveries)).put("cluster.routing.allocation.exclude.tag", "tag_1").build());
        clusterState = this.clusterZoneAwareExcludeStrategy.reroute(clusterState, "reroute");
        while (clusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING}).size() > 0) {
            clusterState = this.clusterZoneAwareExcludeStrategy.applyStartedShards(clusterState, clusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING}));
        }
        for (ShardRouting startedShard : clusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.STARTED})) {
            assert (((String)clusterState.getRoutingNodes().node(startedShard.currentNodeId()).node().getAttributes().get("tag")).equals("tag_0"));
        }
        return clusterState;
    }

    private DiscoveryNodes.Builder setUpClusterNodes(int sourceNodes, int targetNodes) {
        HashMap<String, String> attributes;
        DiscoveryNodes.Builder nb = DiscoveryNodes.builder();
        for (int i = 1; i <= sourceNodes; ++i) {
            attributes = new HashMap<String, String>();
            attributes.put("tag", "tag_1");
            attributes.put("zone", "zone_" + i % this.numZone);
            nb.add(Allocators.newNode("node_s_" + i, attributes));
        }
        for (int j = 1; j <= targetNodes; ++j) {
            attributes = new HashMap();
            attributes.put("tag", "tag_0");
            attributes.put("zone", "zone_" + j % this.numZone);
            nb.add(Allocators.newNode("node_t_" + j, attributes));
        }
        return nb;
    }
}

