/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.benchmark.indices.breaker;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Fork(value=3)
@Warmup(iterations=10)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Benchmark)
public class MemoryStatsBenchmark {
    private static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
    @Param(value={"0", "16", "256", "4096"})
    private int tokens;

    @Benchmark
    public void baseline() {
        Blackhole.consumeCPU((long)this.tokens);
    }

    @Benchmark
    @Threads(value=1)
    public long getMemoryStats_01() {
        Blackhole.consumeCPU((long)this.tokens);
        return MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
    }

    @Benchmark
    @Threads(value=2)
    public long getMemoryStats_02() {
        Blackhole.consumeCPU((long)this.tokens);
        return MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
    }

    @Benchmark
    @Threads(value=4)
    public long getMemoryStats_04() {
        Blackhole.consumeCPU((long)this.tokens);
        return MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
    }

    @Benchmark
    @Threads(value=8)
    public long getMemoryStats_08() {
        Blackhole.consumeCPU((long)this.tokens);
        return MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
    }

    @Benchmark
    @Threads(value=16)
    public long getMemoryStats_16() {
        Blackhole.consumeCPU((long)this.tokens);
        return MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
    }

    @Benchmark
    @Threads(value=32)
    public long getMemoryStats_32() {
        Blackhole.consumeCPU((long)this.tokens);
        return MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
    }

    @Benchmark
    @Threads(value=64)
    public long getMemoryStats_64() {
        Blackhole.consumeCPU((long)this.tokens);
        return MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
    }
}

